/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "configdialog.h"

ConfigDialog::ConfigDialog(QString dataDirectory,
                           int updateInterval, int postsPerPage, int tabsPosition,
                           bool tabsMovable, int publisherType, bool publicPosts,
                           int showNotifications, QWidget *parent) : QWidget(parent)
{
    this->setWindowTitle("Dianara - " + tr("Program Configuration"));
    this->setWindowIcon(QIcon::fromTheme("configure"));
    this->setWindowFlags(Qt::Window);
    this->setWindowModality(Qt::ApplicationModal);
    this->setMinimumSize(480, 320);


    // Upper part

    optionsLayout = new QFormLayout();

    updateIntervalSpinbox = new QSpinBox();
    updateIntervalSpinbox->setRange(2, 60); // 2-60 min
    updateIntervalSpinbox->setSuffix(" "+ tr("minutes"));
    updateIntervalSpinbox->setValue(updateInterval);
    optionsLayout->addRow(tr("Timeline &update interval"), updateIntervalSpinbox);

    postsPerPageSpinbox = new QSpinBox();
    postsPerPageSpinbox->setRange(10, 100); // 10-100 ppp
    postsPerPageSpinbox->setSuffix(" "+ tr("posts"));
    postsPerPageSpinbox->setValue(postsPerPage);
    optionsLayout->addRow(tr("&Posts per page"), postsPerPageSpinbox);


    tabsPositionCombobox = new QComboBox();
    tabsPositionCombobox->addItem(QIcon::fromTheme("arrow-up"),
                                  tr("Top"));
    tabsPositionCombobox->addItem(QIcon::fromTheme("arrow-down"),
                                  tr("Bottom"));
    tabsPositionCombobox->addItem(QIcon::fromTheme("arrow-left"),
                                  tr("Left side"));
    tabsPositionCombobox->addItem(QIcon::fromTheme("arrow-right"),
                                  tr("Right side"));
    tabsPositionCombobox->setCurrentIndex(tabsPosition);
    optionsLayout->addRow(tr("&Tabs position"), tabsPositionCombobox);


    tabsMovableCheckbox = new QCheckBox();
    tabsMovableCheckbox->setChecked(tabsMovable);
    optionsLayout->addRow(tr("&Movable tabs"), tabsMovableCheckbox);


    publisherTypeCombobox = new QComboBox();
    publisherTypeCombobox->addItem(tr("Buttons below"));
    publisherTypeCombobox->addItem(tr("Buttons around"));
    publisherTypeCombobox->addItem(tr("Buttons on right side"));
    publisherTypeCombobox->setCurrentIndex(publisherType);
    publisherTypeCombobox->setToolTip(tr("Restart program to apply this change"));
    optionsLayout->addRow(tr("C&omposer type"), publisherTypeCombobox);


    publicPostsCheckbox = new QCheckBox();
    publicPostsCheckbox->setChecked(publicPosts);
    optionsLayout->addRow(tr("Public posts as &default"), publicPostsCheckbox);


    showNotificationsCombobox = new QComboBox();
    showNotificationsCombobox->addItem(QIcon::fromTheme("preferences-desktop-notification"),
                                       tr("As system notifications"));
    showNotificationsCombobox->addItem(QIcon::fromTheme("view-conversation-balloon"),
                                       tr("Using own notifications"));
    showNotificationsCombobox->addItem(QIcon::fromTheme("user-busy"), // dialog-cancel
                                       tr("Don't show notifications"));
    showNotificationsCombobox->setCurrentIndex(showNotifications);
    optionsLayout->addRow(tr("Show &notifications"), showNotificationsCombobox);


    // Label to show where the data directory is
    dataDirectoryLabel = new QLabel(tr("Dianara stores data in this folder:")
                                    + QString(" <a href=\"%1\">%2</a>")
                                      .arg(dataDirectory).arg(dataDirectory));
    dataDirectoryLabel->setWordWrap(true);
    dataDirectoryLabel->setOpenExternalLinks(true);
    QFont dataDirectoryFont;
    dataDirectoryFont.setPointSize(dataDirectoryFont.pointSize() - 1);
    dataDirectoryLabel->setFont(dataDirectoryFont);


    //// Bottom part

    saveConfigButton = new QPushButton(QIcon::fromTheme("document-save"),
                                 tr("&Save Configuration"));
    connect(saveConfigButton, SIGNAL(clicked()),
            this, SLOT(saveConfiguration()));
    cancelButton = new QPushButton(QIcon::fromTheme("dialog-cancel"),
                                   tr("&Cancel"));
    connect(cancelButton, SIGNAL(clicked()),
            this, SLOT(hide()));

    this->buttonsLayout = new QHBoxLayout();
    buttonsLayout->setAlignment(Qt::AlignRight);
    buttonsLayout->addWidget(saveConfigButton);
    buttonsLayout->addWidget(cancelButton);


    // Set up main layout

    mainLayout = new QVBoxLayout();
    mainLayout->addLayout(optionsLayout, 2);
    mainLayout->addSpacing(16);
    mainLayout->addStretch(1);
    mainLayout->addWidget(dataDirectoryLabel);
    mainLayout->addSpacing(16);
    mainLayout->addStretch(1);
    mainLayout->addLayout(buttonsLayout);
    this->setLayout(mainLayout);


    qDebug() << "Config dialog created";
}

ConfigDialog::~ConfigDialog()
{
    qDebug() << "Config dialog destroyed";
}



///////////////////////////////// SLOTS //////////////////////////////////////



void ConfigDialog::saveConfiguration()
{
    emit configurationChanged(updateIntervalSpinbox->value(),
                              postsPerPageSpinbox->value(),
                              tabsPositionCombobox->currentIndex(),
                              tabsMovableCheckbox->isChecked(),
                              publisherTypeCombobox->currentIndex(),
                              publicPostsCheckbox->isChecked(),
                              showNotificationsCombobox->currentIndex());
    qDebug() << "ConfigDialog: config saved";

    this->hide();   // this->close() would end the program if mainWindow was hidden
}
