/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef COMMENT_H
#define COMMENT_H

#include <QFrame>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>
#include <QIcon>
#include <QVariantMap>
#include <QMessageBox>
#include <QEvent>
#include <QResizeEvent>

#include <QDebug>

#include "pumpcontroller.h"
#include "mischelpers.h"
#include "timestamp.h"


class Comment : public QFrame
{
    Q_OBJECT

public:
    explicit Comment(PumpController *pumpController,
                     QVariantMap commentMap,
                     QWidget *parent = 0);
    ~Comment();

    void fixLikeLabelText();
    void setLikesCount(int count, QVariantList namesVariantList);

    void setCommentContents();
    void setCommentHeight();
    void enqueueImageForDownload(QString url);


signals:
    void commentQuoteRequested(QString content);


public slots:
    void likeComment(QString clickedLink);
    void quoteComment();
    void deleteComment();

    void showUrlInfo(QString url);

    void redrawAvatar(QString avatarUrl, QString avatarFilename);
    void redrawImages(QString imageUrl);

protected:
    virtual void leaveEvent(QEvent *event);


private:
    QHBoxLayout *mainLayout;
    QVBoxLayout *leftLayout;
    QVBoxLayout *rightLayout;
    QHBoxLayout *rightTopLayout;

    QLabel *avatarLabel;
    QLabel *fullNameLabel;
    QLabel *timestampLabel;
    QLabel *contentLabel;
    QLabel *likesCountLabel;

    QLabel *likeLabel;
    QLabel *quoteLabel;
    QLabel *deleteLabel;

    QHBoxLayout *contentLabelLayout;
    QLabel *urlInfoLabel;

    QString commentID;
    QString objectType;
    QString commentAuthorAvatarUrl;

    bool commentIsOwn;
    bool commentIsLiked;
    QString commentOriginalText;
    QStringList pendingImagesList;


    PumpController *pController;
};

#endif // COMMENT_H
