/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef ACCOUNT_H
#define ACCOUNT_H

#include <QWidget>
#include <QSettings>
#include <QGridLayout>
#include <QIcon>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QByteArray>
#include <QDebug>

#include "pumpcontroller.h"


class AccountDialog : public QWidget
{
    Q_OBJECT

public:
    AccountDialog(PumpController *pumpController, QWidget *parent = 0);
    ~AccountDialog();

signals:
    void userIDChanged(QString newUserID);

public slots:
    void askForToken();
    void setVerifierCode();
    void showAuthorizationStatus(bool authorized);
    void showAuthorizationURL(QUrl url);

    void saveDetails();

private:
    QGridLayout *mainLayout;

    QLabel *userIDIconLabel;
    QLabel *userIDLabel;
    QLineEdit *userIDLineEdit;

    QPushButton *getVerifierButton;

    QLabel *verifierIconLabel;
    QLabel *verifierLabel;
    QLineEdit *verifierLineEdit;

    QPushButton *authorizeApplicationButton;

    QLabel *errorsLabel;
    QLabel *authorizationStatusLabel;

    QPushButton *saveButton;
    QPushButton *cancelButton;

    PumpController *pController;

};

#endif // ACCOUNT_H
