/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef PUBLISHER_H
#define PUBLISHER_H

#include <QWidget>
#include <QGridLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QMenu>
#include <QFileDialog>
#include <QImageReader>
#include <QMessageBox>

#include <QDebug>

#include "composer.h"
#include "pumpcontroller.h"
#include "mischelpers.h"
#include "audienceselector.h"


class Publisher : public QWidget
{
    Q_OBJECT

public:
    explicit Publisher(PumpController *pumpController,
                       int publisherType,
                       QWidget *parent = 0);
    ~Publisher();

    void setDefaultPublicPosting(bool defaultPublicPosts);
    void setEmptyPictureData();

    QMap<QString,QString> getAudienceMap();


signals:


public slots:
    void setMinimumMode();
    void setFullMode();
    void setPictureMode();

    void findPictureFile();

    void updateToCcFields(QString selectorType,
                          QStringList contactsList);

    void sendPost();

private:
    QGridLayout *mainLayout;

    QLineEdit *titleLineEdit;
    QLabel *pictureLabel;
    QPushButton *selectPictureButton;

    Composer *composerBox;


    QMenu *toSelectorMenu;
    QPushButton *toSelectorButton;
    QMenu *ccSelectorMenu;
    QPushButton *ccSelectorButton;

    AudienceSelector *audienceSelectorTo;
    AudienceSelector *audienceSelectorCC;

    QLabel *toAudienceLabel;
    QLabel *ccAudienceLabel;

    QStringList toAddressStringList;
    QStringList ccAddressStringList;

    bool defaultPublicPosting;


    QPushButton *pictureButton;
    QPushButton *postButton;


    QString pictureFilename;
    QString pictureContentType;


    PumpController *pController;
};

#endif // PUBLISHER_H
