/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "minorfeed.h"


MinorFeed::MinorFeed(PumpController *pumpController,
                     QWidget *parent) : QTextBrowser(parent)
{
    this->pController = pumpController;

    QFont mainFont;
    mainFont.setPointSize(mainFont.pointSize() - 2);

    this->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
    this->setAlignment(Qt::AlignTop | Qt::AlignLeft);
    this->setWordWrapMode(QTextOption::WrapAtWordBoundaryOrAnywhere);
    this->setFont(mainFont);
    this->setOpenExternalLinks(true);
    //mainLabel->setTextFormat(Qt::RichText);

    qDebug() << "MinorFeed created";
}



void MinorFeed::updateFeed()
{
    this->pController->getMinorFeed();
}



void MinorFeed::setFeedContents(QVariantList activitiesList)
{
    QString activitiesString;

    QString activityTime;
    QString activityDescription;
    QString activityObjectContent;
    QString activityObjectAuthor;
    QString activityActorAvatarURL;
    QString activityActorAvatarFilename;


    QTextDocument tooltipDocument;
    QString tooltipString;

    foreach (QVariant activityVariant, activitiesList)
    {
        activityTime = activityVariant.toMap()["updated"].toString();
        activityDescription = activityVariant.toMap()["content"].toString();

        activityActorAvatarURL = activityVariant.toMap()["actor"].toMap()["image"].toMap()["url"].toString();
        activityActorAvatarFilename = MiscHelpers::getCachedAvatarFilename(activityActorAvatarURL);
        if (!QFile::exists(activityActorAvatarFilename))
        {
            this->pController->getAvatar(activityActorAvatarURL);
        }

        activityObjectContent = activityVariant.toMap()["object"].toMap()["content"].toString();
        activityObjectContent.replace(". ", ".<br>"); // VERY, VEEERY TMP -- FIXME

        activityObjectAuthor = activityVariant.toMap()["object"].toMap()["author"].toMap()["displayName"].toString();

        tooltipDocument.setHtml(activityObjectContent);

        tooltipString = Timestamp::localTimeDate(activityTime);
        if (!activityObjectAuthor.isEmpty())
        {
            tooltipString += "\n\n\n"
                             "[ " + activityObjectAuthor + " ]"
                             "\n";
        }
        tooltipString += "\n"
                         + tooltipDocument.toPlainText();

        activitiesString.append("<table>"
                                "<tr>"

                                "<td>"
                                "<img align=\"left\" width=\"32\" src=\"" + activityActorAvatarFilename +  "\" />"
                                "</td>"

                                "<td>"
                                "<span title=\"" + tooltipString + "\" >"
                                "<b>[ "+ Timestamp::fuzzyTime(activityTime) + " ]</b>"
                                "<br>"
                                + activityDescription
                                + "</span>"
                                "</td>"
                                "</tr>"
                                "</table>"
                                "<br>");
    }


    this->setHtml(activitiesString);
}

