/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "minorfeed.h"


MinorFeed::MinorFeed(PumpController *pumpController,
                     QWidget *parent) : QFrame(parent)
{
    this->pController = pumpController;

    this->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);


    QFont mainLabelFont;
    mainLabelFont.setPointSize(mainLabelFont.pointSize() - 2);

    mainLabel = new QLabel();
    mainLabel->setAlignment(Qt::AlignTop | Qt::AlignLeft);
    mainLabel->setTextFormat(Qt::RichText);
    mainLabel->setWordWrap(true);
    mainLabel->setFont(mainLabelFont);
    mainLabel->setOpenExternalLinks(true);


    mainLayout = new QVBoxLayout();
    mainLayout->addWidget(mainLabel);

    this->setLayout(mainLayout);


    qDebug() << "MinorFeed created";
}



void MinorFeed::updateFeed()
{
    this->pController->getMinorFeed();
}



void MinorFeed::setFeedContents(QVariantList activitiesList)
{
    QString activitiesString;

    QString activityTime;
    QString activityDescription;


    foreach (QVariant activityVariant, activitiesList)
    {
        activityTime = activityVariant.toMap().value("updated").toString();
        activityDescription = activityVariant.toMap().value("content").toString();

        activitiesString.append("[<b>"+ Timestamp::fuzzyTime(activityTime) + "]</b><br>"
                                + activityDescription + "<br><br>");
    }


    mainLabel->setText(activitiesString);
}

