/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "configdialog.h"

ConfigDialog::ConfigDialog(int updateInterval, int postsPerPage, int tabsPosition,
                           bool tabsMovable, int publisherType, int showNotifications)
{
    this->setWindowTitle(tr("Configure Dianara"));
    this->setWindowIcon(QIcon::fromTheme("configure"));
    this->setMinimumSize(450, 300);

    mainLayout = new QGridLayout();

    updateIntervalLabel = new QLabel(tr("Timeline update interval"));
    updateIntervalLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
    mainLayout->addWidget(updateIntervalLabel, 0, 0);

    updateIntervalSpinbox = new QSpinBox();
    updateIntervalSpinbox->setRange(2, 60); // 2-60 min
    updateIntervalSpinbox->setSuffix(" "+ tr("minutes"));
    updateIntervalSpinbox->setValue(updateInterval);
    mainLayout->addWidget(updateIntervalSpinbox, 0, 1);

    postsPerPageLabel = new QLabel(tr("Posts per page"));
    postsPerPageLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
    mainLayout->addWidget(postsPerPageLabel, 1, 0);

    postsPerPageSpinbox = new QSpinBox();
    postsPerPageSpinbox->setRange(10, 100); // 10-100 ppp
    postsPerPageSpinbox->setSuffix(" "+ tr("posts"));
    postsPerPageSpinbox->setValue(postsPerPage);
    mainLayout->addWidget(postsPerPageSpinbox, 1, 1);


    tabsPositionLabel = new QLabel(tr("Tabs position"));
    tabsPositionLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
    mainLayout->addWidget(tabsPositionLabel, 2, 0);


    tabsPositionCombobox = new QComboBox();
    tabsPositionCombobox->addItem(QIcon::fromTheme("arrow-up"),
                                  tr("Top"));
    tabsPositionCombobox->addItem(QIcon::fromTheme("arrow-down"),
                                  tr("Bottom"));
    tabsPositionCombobox->addItem(QIcon::fromTheme("arrow-left"),
                                  tr("Left side"));
    tabsPositionCombobox->addItem(QIcon::fromTheme("arrow-right"),
                                  tr("Right side"));
    tabsPositionCombobox->setCurrentIndex(tabsPosition);
    mainLayout->addWidget(tabsPositionCombobox, 2, 1);



    tabsMovableLabel = new QLabel(tr("Movable tabs"));
    tabsMovableLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
    mainLayout->addWidget(tabsMovableLabel, 3, 0);


    tabsMovableCheckbox = new QCheckBox();
    tabsMovableCheckbox->setChecked(tabsMovable);
    mainLayout->addWidget(tabsMovableCheckbox, 3, 1);



    publisherTypeLabel = new QLabel(tr("Composer type"));
    publisherTypeLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
    mainLayout->addWidget(publisherTypeLabel, 4, 0);


    publisherTypeCombobox = new QComboBox();
    publisherTypeCombobox->addItem(tr("Buttons below"));
    publisherTypeCombobox->addItem(tr("Buttons around"));
    publisherTypeCombobox->addItem(tr("Buttons on right side"));
    publisherTypeCombobox->setCurrentIndex(publisherType);
    publisherTypeCombobox->setToolTip(tr("Restart program to apply this change"));
    mainLayout->addWidget(publisherTypeCombobox, 4, 1);



    showNotificationsLabel = new QLabel(tr("Show notifications"));
    showNotificationsLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
    mainLayout->addWidget(showNotificationsLabel, 5, 0);

    showNotificationsCombobox = new QComboBox();
    showNotificationsCombobox->addItem(QIcon::fromTheme("preferences-desktop-notification"),
                                       tr("As system notifications"));
    showNotificationsCombobox->addItem(QIcon::fromTheme("view-conversation-balloon"),
                                       tr("Using own notifications"));
    showNotificationsCombobox->addItem(QIcon::fromTheme("user-busy"), // dialog-cancel
                                       tr("Don't show notifications"));
    showNotificationsCombobox->setCurrentIndex(showNotifications);
    mainLayout->addWidget(showNotificationsCombobox, 5, 1);



    saveConfigButton = new QPushButton(QIcon::fromTheme("document-save"),
                                 tr("&Save configuration"));
    connect(saveConfigButton, SIGNAL(clicked()),
            this, SLOT(saveConfiguration()));
    mainLayout->addWidget(saveConfigButton, 10, 0,
                          1, 1, Qt::AlignRight);
    cancelButton = new QPushButton(QIcon::fromTheme("dialog-cancel"),
                                   tr("&Cancel"));
    connect(cancelButton, SIGNAL(clicked()),
            this, SLOT(hide()));
    mainLayout->addWidget(cancelButton, 10, 1,
                          1, 1, Qt::AlignRight);


    this->setLayout(mainLayout);


    qDebug() << "Config dialog created";
}

ConfigDialog::~ConfigDialog()
{
    qDebug() << "Config dialog destroyed";
}


//////// SLOTS


void ConfigDialog::saveConfiguration()
{
    emit configurationChanged(updateIntervalSpinbox->value(),
                              postsPerPageSpinbox->value(),
                              tabsPositionCombobox->currentIndex(),
                              tabsMovableCheckbox->isChecked(),
                              publisherTypeCombobox->currentIndex(),
                              showNotificationsCombobox->currentIndex());
    qDebug() << "ConfigDialog: saved config";

    this->hide();   // this->close() would end the program if mainWindow was hidden
}
