/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */


#include "messagelist.h"

MessageList::MessageList(QWidget *parent) :  QWidget(parent)
{
    mainLayout = new QHBoxLayout();


    messageTable = new QTableWidget(15, 2);
    messageTable->setHorizontalHeaderLabels(QStringList() << tr("Sender")
                                                          << tr("Subject") );
    messageTable->setEditTriggers(QTableWidget::NoEditTriggers);
    messageTable->setSelectionBehavior(QAbstractItemView::SelectRows);
    messageTable->setShowGrid(false);
    messageTable->setAlternatingRowColors(true);
    messageTable->setSizePolicy(QSizePolicy::MinimumExpanding,
                                QSizePolicy::MinimumExpanding);


    messageTable->setItem(0, 0, new QTableWidgetItem("John Doe", 0));
    messageTable->setItem(0, 1, new QTableWidgetItem("message 1 subject", 0));

    messageTable->setItem(1, 0, new QTableWidgetItem("Jane", 0));
    messageTable->setItem(1, 1, new QTableWidgetItem("second", 0));

    messageTable->setItem(2, 0, new QTableWidgetItem("KDE", 0));
    messageTable->setItem(2, 1, new QTableWidgetItem("3rd message", 0));

    messageTable->setItem(3, 0, new QTableWidgetItem("Pump User", 0));
    messageTable->setItem(3, 1, new QTableWidgetItem("fourth message, long title", 0));


    //messageTable->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    // Enable sorting AFTER inserting items
    //messageTable->setSortingEnabled(true);

    messageTable->setWordWrap(true);
    messageTable->resizeRowsToContents();
    messageTable->resizeColumnsToContents();


    conversationHeaderLabel = new QLabel(tr("Select a conversation from the list"));
    conversationHeaderLabel->setAlignment(Qt::AlignTop | Qt::AlignLeft);


    connect(messageTable, SIGNAL(itemSelectionChanged()),
            this, SLOT(loadConversation()));


    mainLayout->addWidget(messageTable,            4);
    mainLayout->addWidget(conversationHeaderLabel, 6);

    this->setLayout(mainLayout);
    qDebug() << "MessageList created";
}


MessageList::~MessageList()
{
    qDebug() << "MessageList destroyed";
}




void MessageList::loadConversation()
{

    QString conversationStarter;
    QString participants;
    QString subject;

    int row = messageTable->currentRow();

    // If selected row is empty, do nothing
    if (messageTable->item(row, 0) == NULL)
    {
        qDebug() << "Item was NULL, ignoring row" << row;
        return;
    }

    conversationStarter = messageTable->item(row, 0)->text();
    participants = conversationStarter + ", User A, User B, User C";

    subject = messageTable->item(row, 1)->text();

    // FIXME: avoid (and provent) HTML
    //this->conversationHeaderLabel->setTextFormat(Qt::PlainText);
    this->conversationHeaderLabel->setText(tr("Conversation started by: %1").arg(conversationStarter)
                                         + "<br />"
                                         + tr("Participants: %1").arg(participants)
                                         + "<h2><b>"
                                         + tr("Subject: %1").arg(subject)
                                         + "</b></h2>"
                                         + "<br />"
         +
         "(message 1 here)<br /><br />"
         "(message 2 here)<br /><br />"
         "(message 3 here)<br />");


    qDebug() << "loaded conversation at" << row;
}
