/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "timeline.h"

TimeLine::TimeLine(PumpController *pumpController, QWidget *parent) :  QWidget(parent)
{
    this->pController = pumpController;

    mainLayout = new QVBoxLayout();
    mainLayout->setAlignment(Qt::AlignTop);


    QMap<QString,QString> demoPostData;
    demoPostData.insert("author", "DemoUser");
    demoPostData.insert("text",   "<h2><b>Demo Post</b></h2><br>"
                                  "Press <b>F5</b> or <i>Update timelines</i> in the menu.<br><br>"
                                  "Upon startup, timeline should update automatically.<br><br>"
                                  "<a href=\"http://dianara.nongnu.org\">Dianara's website</a><br><br>"
                                  "<a href=\"http://jancoding.wordpress.com/dianara\">Dianara's blog</a>");
    demoPostData.insert("createdAt", "1970-01-01T01:02:03Z");
    demoPostData.insert("likesCount", "32");
    demoPostData.insert("commentsCount", "256");
    demoPostData.insert("resharesCount", "1024");


    splitter = new QSplitter(Qt::Vertical, this);
    splitter->setChildrenCollapsible(false);
    mainLayout->addWidget(splitter);


    previousButton = new QPushButton(QIcon::fromTheme("go-previous"), tr("Previous Page"));
    nextButton = new QPushButton(QIcon::fromTheme("go-next"), tr("Next Page"));

    bottomLayout = new QHBoxLayout();
    bottomLayout->addWidget(previousButton);
    bottomLayout->addWidget(nextButton);
    mainLayout->addLayout(bottomLayout);

    // Add the default "demo" post
    splitter->addWidget(new Post(pController, demoPostData, this));


    this->setLayout(mainLayout);

    qDebug() << "TimeLine created";
}


TimeLine::~TimeLine()
{
    qDebug() << "TimeLine destroyed";
}



/*
 * Remove all widgets (Post *) from the timeline
 *
 */
void TimeLine::clearTimeLineContents()
{
    QList<QWidget*> previousPostList;

    // Build list of widgets contained in the layout
    for (int counter = 0; counter < splitter->count(); ++counter)
    {
        qDebug() << "Adding for deletion:" << splitter->widget(counter);

        previousPostList.append(splitter->widget(counter));
    }

    qDebug() << "List to delete:" << previousPostList;


    foreach (QWidget *oldPost, previousPostList)
    {
        //delete mainLayout->itemAt(counter)->widget();
        //mainLayout->itemAt(counter)->widget()->deleteLater();

        qDebug() << "will deleteLater:" << oldPost;
        oldPost->deleteLater(); // delete should be safe too, but still...
    }


    /* This is to avoid the splitter getting bigger and bigger everytime the user
     * updates the timeline (F5, etc)
     */
    this->splitter->setMinimumHeight(0);
    this->splitter->resize(1,1);
}



/************************ SLOTS **************************/


void TimeLine::setTimeLineContents(QVariantList postList)
{
    qDebug() << "TimeLine::setTimeLineContents()";
    //qDebug() << postList;


    // Remove all previous posts in timeline
    qDebug() << "Removing previous posts from timeline";
    this->clearTimeLineContents();


    // Fill timeline with new contents
    foreach (QVariant singlePost, postList)
    {
        if (singlePost.type() == QVariant::Map)
        {
            qDebug() << "Parsed a Map:";
            QVariantMap singlePostMap = singlePost.toMap();

            QString itemVerb = singlePostMap.value("verb").toString();  // if not "post", ignore ("favorite")


            QVariantList postPhotosList;

            QString postID;
            QString postType;
            QString postAuthor;
            QString postAuthorAvatar;
            QString postAuthorId;
            QString postTitle;
            QString postImage;
            QString postText;
            QString postIsNsfw;
            QString postCreatedAt;
            QString postRootAuthor;
            QString postLikesCount;
            QString postCommentsCount;
            QString postResharesCount;
            QString postOembedThumbnailUrl;


            postID = singlePostMap.value("object").toMap().value("id").toString();

            postType = singlePostMap.value("object").toMap().value("objectType").toString();


            // Only "note/image" types accepted, to avoid rendering "comment" posts as normal posts
            // if (itemVerb == "post" && (postType == "note" || postType == "image"))
            // Not needed anymore, since we now get /inbox/major

            postAuthor = singlePostMap.value("actor").toMap().value("displayName").toString();
            postAuthorAvatar = singlePostMap.value("actor").toMap().value("image").toMap().value("url").toString();
            // for Author ID, remove the first 5 characters from the field, "acct:"
            postAuthorId = singlePostMap.value("actor").toMap().value("id").toString().remove(0,5);

            postCreatedAt = singlePostMap.value("object").toMap().value("published").toString();


            ///
            /// End of "meta"; Start of content
            ///

            if (postType == "image")
            {
                postTitle = singlePostMap.value("object").toMap().value("displayName").toString();
                postImage = singlePostMap.value("object").toMap().value("image").toMap().value("url").toString();
            }


            postText = singlePostMap.value("object").toMap().value("content").toString();

            postLikesCount = singlePostMap.value("object").toMap().value("likes").toMap().value("totalItems").toString();
            postCommentsCount = singlePostMap.value("object").toMap().value("replies").toMap().value("totalItems").toString();
            postResharesCount = singlePostMap.value("object").toMap().value("shares").toMap().value("totalItems").toString();


            //qDebug() << "**** likes/comments/reshares:" << postLikesCount << postCommentsCount << postResharesCount;



            // oEmbed stuff (youtube videos, etc.)
            postOembedThumbnailUrl = singlePostMap.value("o_embed_cache").toMap().value("data").toMap().value("thumbnail_url").toString();


            QMap<QString,QString> postData;
            postData.insert("id",                 postID);
            postData.insert("author",             postAuthor);
            postData.insert("authorAvatar",       postAuthorAvatar);
            postData.insert("authorId",           postAuthorId);
            postData.insert("title",              postTitle);
            postData.insert("image",              postImage);
            postData.insert("text",               postText);
            postData.insert("createdAt",          postCreatedAt);
            postData.insert("postType",           postType);
            postData.insert("nsfw",               postIsNsfw);
            postData.insert("rootAuthor",         postRootAuthor);
            postData.insert("likesCount",         postLikesCount);
            postData.insert("commentsCount",      postCommentsCount);
            postData.insert("resharesCount",      postResharesCount);
            postData.insert("oembedThumbnailUrl", postOembedThumbnailUrl);


            // get comments list here, pass to the Post()  // WIP - FIXME
            QVariantList commentsList = singlePostMap.value("last_three_comments").toList();
            qDebug() << ">>>> Last 3 comments:\n";
            foreach (QVariant comment, commentsList)
            {
                qDebug() << comment.toMap().value("author").toMap().value("name");
                qDebug() << comment.toMap().value("text");
                qDebug() << "-------------------------------------";
            }

            this->splitter->addWidget(new Post(pController, postData, this));


            /*
            this->splitter->setStretchFactor(splitter->count()-1,
                                             splitter->widget(splitter->count()-1)->height()/200);
            */

            // TMP FIXME, avoid unresizable posts (not enough height on splitter area)
            //this->splitter->setMinimumHeight(this->splitter->height() + 200); // was 400
        }
        else  // singlePost.type() is not a QVariant::Map
        {
            qDebug() << "Expected a Map, got something else";
            qDebug() << postList;
        }

    }
    qDebug() << "setTimeLineContents() /END";
}
