/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "contactlist.h"

ContactList::ContactList(PumpController *pumpController,
                         QWidget *parent) : QWidget(parent)
{
    this->pController = pumpController;

    mainLayout = new QVBoxLayout();
    mainLayout->setAlignment(Qt::AlignTop);


    QMap<QString,QString> demoContactData;
    demoContactData.insert("name", "Demo Contact");
    demoContactData.insert("id",   "democontact@somepumpserver.org");
    demoContactData.insert("avatar", "");
    demoContactData.insert("sharing", "true");
    demoContactData.insert("receiving", "false");
    mainLayout->addWidget(new ContactCard(this->pController, demoContactData, this));


    this->setLayout(mainLayout);

    qDebug() << "Contact list created";
}


ContactList::~ContactList()
{
    qDebug() << "Contact list destroyed";
}





/*********************************** SLOTS ***********************************/




void ContactList::setContactListContents(QVariantList contactList)
{
    qDebug() << "Setting contact list contents";


    QMap<QString,QString> contactData;

    foreach (QVariant contact, contactList)
    {
        contactData.insert("name", contact.toMap().value("displayName").toString());
        contactData.insert("id", contact.toMap().value("id").toString().remove(0,5)); // remove "acct:"
        contactData.insert("avatar", contact.toMap().value("image").toMap().value("url").toString());
        contactData.insert("sharing", "false"); // tmp, until we have followers/following separation
        contactData.insert("receiving", "true");

        this->mainLayout->addWidget(new ContactCard(this->pController,
                                                    contactData,
                                                    this));
    }
}
