/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "contactcard.h"

ContactCard::ContactCard(PumpController *pumpController,
                         QMap<QString, QString> contactData,
                         QWidget *parent)  :  QFrame(parent)
{
    this->setFrameStyle(QFrame::Box | QFrame::Raised);

    this->setSizePolicy(QSizePolicy::MinimumExpanding,
                        QSizePolicy::Maximum);

    mainLayout = new QHBoxLayout();

    avatarLabel = new QLabel();

    // Get local file name, which is stored in base64 hash form
    QString avatarFilename = MiscHelpers::getCachedAvatarFilename(contactData.value("avatar"));

    qDebug() << "Avatar remote file:" << contactData.value("avatar");
    qDebug() << "Avatar local file:" << avatarFilename;

    QFile avatarFile(avatarFilename);
    if (avatarFile.exists(avatarFilename) && !contactData.value("avatar").isEmpty())
    {
        // Load avatar if already cached
        avatarLabel->setPixmap(QPixmap(avatarFilename).scaled(48, 48,
                                                              Qt::KeepAspectRatio,
                                                              Qt::SmoothTransformation));
        qDebug() << "ContactCard: Using cached avatar";
    }
    else
    {
        // Placeholder image
        avatarLabel->setPixmap(QIcon::fromTheme("user-identity").pixmap(48,48));
        qDebug() << "ContactCard: Using placeholder";

        // Download avatar for next time
        pumpController->getAvatar(contactData.value("avatar"));
    }


    rightLayout = new QVBoxLayout();

    QFont nameFont;
    nameFont.setBold(true);
    nameFont.setUnderline(true);

    nameLabel = new QLabel();
    nameLabel->setText(contactData.value("name"));
    nameLabel->setFont(nameFont);

    tmpLabel = new QLabel();
    tmpLabel->setText(QString("<%1>\n"
                              "%2  /  %3").arg(contactData.value("id"))
                                          .arg(contactData.value("sharing") == "true" ? "Follower" : "*")
                                          .arg(contactData.value("receiving") == "true" ? "Following": "*"));
    tmpLabel->setAlignment(Qt::AlignLeft | Qt::AlignTop);
    //qDebug() << contactData.value("avatar");


    rightLayout->addWidget(nameLabel);
    rightLayout->addWidget(tmpLabel);

    mainLayout->addWidget(avatarLabel, 1);  // Stretch 1/8
    mainLayout->addLayout(rightLayout, 7);  // Stretch 7/8


    this->setLayout(mainLayout);

    qDebug() << "ContactCard created";
}


ContactCard::~ContactCard()
{
    qDebug() << "ContactCard destroyed";
}
