/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <limits.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "nsplit.h"

int open_output_file( int *fd, const char *filename, unsigned short ndx )
{
	int	new_fd;
	char	new_filename[PATH_MAX];

	assert( fd != (int *)0 );
	assert( filename != (const char *)0 );

	DEBUG_FUNC_START;

	(void) snprintf( new_filename, sizeof( new_filename ), filename, ndx );

	new_fd = open( new_filename, O_WRONLY|O_CREAT|O_TRUNC, (mode_t)0666 );

	if ( new_fd < 0 ) {
		UNIX_ERROR( "open() failed" );
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Could not open output file [", stderr );
		(void) fputs( new_filename, stderr );
		(void) fputs( "].\n", stderr );
		RETURN_INT( -1 );
	}

	*fd = new_fd;

	if ( Debug ) {
		(void) fprintf( stderr, "[%s], %d\n", new_filename, *fd );
	}

	RETURN_INT( 0 );
}
