/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "nsplit.h"

int open_input_file( int *fd, off_t *filesize, size_t *io_blksize, const char *filename )
{
	int	new_fd;
	struct stat	fs;
	const size_t	minimum_blksize = 512;

	assert( fd != (int *)0 );
	assert( filesize != (off_t *)0 );
	assert( io_blksize != (size_t *)0 );
	assert( filename != (const char *)0 );

	DEBUG_FUNC_START;

	new_fd = open( filename, O_RDONLY );

	if ( new_fd < 0 ) {
		UNIX_ERROR( "open() failed" );
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Could not open input file [", stderr );
		(void) fputs( filename, stderr );
		(void) fputs( "].\n", stderr );
		RETURN_INT( -1 );
	}

	if ( fstat( new_fd, &fs ) < 0 ) {
		UNIX_ERROR( "fstat() failed" );
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Could not fstat() input file [", stderr );
		(void) fputs( filename, stderr );
		(void) fputs( "].\n", stderr );
		RETURN_INT( -1 );
	}

	if ( (size_t)fs.st_blksize < minimum_blksize ) {
		*io_blksize = minimum_blksize;
	} else {
		*io_blksize = (size_t)fs.st_blksize;
	}

	*fd = new_fd;
	*filesize = fs.st_size;

	if ( Debug ) {
		(void) fprintf( stderr, "[%s], %d, %d, %lu\n", filename, *fd, *io_blksize, *filesize );
	}

	RETURN_INT( 0 );
}
