/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "where.h"
#include "_where.h"


/*
** This is a wrapper function for _where_condition. It executes the filter
** interpreter.
*/

int where_condition( where_result_t *result, char *err_msg, size_t err_msg_size, void *condition )
{
	int	ret;

	assert( result != (where_result_t *)0 );
	assert( condition != (void *)0 );

	DEBUG_FUNC_START;

	ret = _where_condition( result, (condition_t *)condition );

	if ( ret != WHERE_NOERR ) {
		if ( err_msg != (char *)0 && err_msg_size > (size_t)0 ) {
			--err_msg_size;
			(void) strncpy( err_msg, where_error( ret ), err_msg_size );
			err_msg[ err_msg_size ] = (char)0;
		}
	}

	RETURN_INT( ret );
}
