/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "where.h"
#include "_where.h"


/*
** This function is part of interpreter that evaluates AND & OR expressions.
*/

int _where_multi_condition( where_result_t *ret_result, multi_cond_t *multi_cond, operation_type_t operation )
{
	int	ret;
	where_result_t	result;
	unsigned long	ndx, condition_cnt;
	condition_t	*condition;

	assert( ret_result != (where_result_t *)0 );
	assert( multi_cond != (multi_cond_t *)0 );
	assert( operation == And || operation == Or );

	DEBUG_FUNC_START;

	condition = multi_cond->condition;
	condition_cnt = multi_cond->condition_cnt;

	for ( ndx = 0UL; ndx < condition_cnt; ++ndx ) {
		ret = _where_condition( &result, condition );
		if ( ret != WHERE_NOERR ) {
			RETURN_INT( ret );
		}

		switch ( operation ) {
		case Or:
			if ( result == Where_result_true ) {
				*ret_result = Where_result_true;

				if ( Debug ) {
					(void) fputs( "true\n", stderr );
				}

				RETURN_INT( WHERE_NOERR );
			}
			break;

		case And:
			if ( result == Where_result_false ) {
				*ret_result = Where_result_false;

				if ( Debug ) {
					(void) fputs( "false\n", stderr );
				}

				RETURN_INT( WHERE_NOERR );
			}
			break;

		default:
			FPUT_SRC_CODE( stderr );
			(void) fputs( "programming error--unexpected operation [", stderr );
			(void) fput_int( (int)operation, stderr );
			(void) fputs( "] encountered.\n", stderr );
			abort();
		}

		++condition;
	}

	switch ( operation ) {
	case Or:
		*ret_result = Where_result_false;
		break;
	case And:
		*ret_result = Where_result_true;
		break;
	default:
		FPUT_SRC_CODE( stderr );
		(void) fputs( "programming error--unexpected operation [", stderr );
		(void) fput_int( (int)operation, stderr );
		(void) fputs( "] encountered.\n", stderr );
		abort();
	}


	if ( Debug ) {
		switch ( *ret_result ) {
		case Where_result_true:
			(void) fputs( "true\n", stderr );
			break;
		case Where_result_false:
			(void) fputs( "false\n", stderr );
		}
	}

	RETURN_INT( WHERE_NOERR );
}
