/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <errno.h>
#include "tbox.h"


/*
** This function prints a thread error message.
*/
void thread_error( const char *user_msg, const char *module, int line, int error_code )

{
	const char	*unix_msg;

	assert( user_msg != (char *) 0 );
	assert( module != (char *) 0 );
	assert( line > 0 );

	if ( Debug ) {
		(void) fputs( "Start ", stderr );
		(void) fputs( __func__, stderr );
		(void) fputs( "()\n", stderr );
	}

	if ( ( unix_msg = strerror( error_code ) ) == (char *) 0 ) {
		unix_msg = "ERROR MESSAGE WAS NOT FOUND";
	}

	(void) fputs( get_ctime(), stderr );
	(void) fputc( ' ', stderr );
	(void) fputs( module, stderr );
	(void) fputc( '(', stderr );
	(void) fprintf( stderr, "%d", line );
	(void) fputs( "): ", stderr );
	(void) fputs( user_msg, stderr );
	(void) fputs( "\n   + ** THREAD ERROR ", stderr );
	(void) fprintf( stderr, "%d", error_code );
	(void) fputs( " **, ", stderr );
	(void) fputs( unix_msg, stderr );
	(void) fputc( '\n', stderr );

	if ( Debug ) {
		(void) fputs( "End ", stderr );
		(void) fputs( __func__, stderr );
		(void) fputs( "() returning no value\n", stderr );
	}
}

#ifdef MT_thread_error

#include <stdlib.h>
/*
** This function is used to regression test thread_error().
** The following command is used to compile:
**   x=thread_error; make "MT_CC=-DMT_$x" "MT_PRE=DEFINE=MT_$x" $x
*/
int main( void )

{
	static const char	complete_msg[] =  ">>> Module test on function %s() is complete.\n";
	static const char	test_func[] = "thread_error";
	static const char	blank_line[] = ">>>\n";

	Debug = 1;

	(void) fprintf( stderr, ">>> Start module test on function %s().\n", test_func );
	(void) fputs( blank_line, stderr );
	(void) fputs( ">>> TEST CASE #1\n", stderr );
	(void) fputs( ">>> Check failure for incorrect error code value.\n", stderr );
	(void) fputs( blank_line, stderr );

	thread_error( "error code value 10,000", __FILE__, __LINE__, 10000 );

	(void) fputs( blank_line, stderr );
	(void) fputs( ">>> TEST CASE #2\n", stderr );
	(void) fputs( ">>> Check failure for good error code value.\n", stderr );
	(void) fputs( blank_line, stderr );

	thread_error( "error code value 0", __FILE__, __LINE__, 0 );

	(void) fputs( blank_line, stderr );
	(void) fputs( ">>> TEST CASE #3\n", stderr );
	(void) fputs( ">>> Check correct response to failure EINVAL.\n", stderr );
	(void) fputs( blank_line, stderr );

	thread_error( "EINVAL failure", __FILE__, __LINE__, EINVAL );

	(void) fputs( blank_line, stderr );
	(void) fprintf( stderr, complete_msg, test_func );
	(void) fputs( blank_line, stderr );
	exit( 0 );
}
#endif
