/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"


/*
** This function formats sexpr_t structure to an ASCII string.
** Return value is zero for okay, -1 for UNIX error and positive value
** to represent particular s-expression failure.
*/

int _sexpr_format_list( char **str, size_t *str_avail, const sexpr_t *sexpr, unsigned long depth )
{
	const sexpr_value_t	*value;
	int	ret;

	assert( sexpr != (const sexpr_t *)0 );
	assert( sexpr->car.type == list_sexpr );
	assert( str != (char **)0 );
	assert( str_avail != (size_t *)0 );

	DEBUG_FUNC_START;

	if ( *str_avail < (size_t)2 ) {
		RETURN_INT( SEXPR_NOSPACE );
	}

	**str = '(';
	++*str;
	**str = ' ';
	++*str;
	*str_avail -= (size_t)2;

	sexpr = sexpr->car.value_u.list;

	while ( sexpr != (sexpr_t *)0 ) {
		value = &sexpr->car;
		if ( value->type == list_sexpr ) {
			ret = _sexpr_format_list( str, str_avail, sexpr, depth + 1UL );
			if ( ret != 0 ) {
				RETURN_INT( ret );
			}
		} else {
			if ( value->type == string_sexpr ) {
				ret = _sexpr_format_string( str, str_avail, value->value_u.string );
				if ( ret != 0 ) {
					RETURN_INT( ret );
				}
			} else {
				RETURN_INT( SEXPR_UNKNVAL );
			}
		}

		assert( sexpr->cdr.type == list_sexpr );
		sexpr = sexpr->cdr.value_u.list;
	}

	if ( *str_avail < (size_t)1 ) {
		RETURN_INT( SEXPR_NOSPACE );
	}

	**str = ')';
	++*str;
	--*str_avail;

	if ( depth > 0UL ) {
		**str = ' ';
		++*str;
		--*str_avail;
	}

	RETURN_INT( 0 );
}
