/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"


/*
** This function sums field lengths.
*/
size_t sum_field_length( const dfile_bind_t *bind, unsigned short bind_cnt )
{
	static const char	end_msg[] = "End %s() returning %u at %s\n";
	size_t	record_size;

	assert( bind != (const dfile_bind_t *)0 );
	assert( bind_cnt > (unsigned short)0 );

	DEBUG_FUNC_START;

	/*
	** Calculate record size.
	*/
	record_size = (size_t)0;

	for ( ; bind_cnt > (unsigned short)0; --bind_cnt ) {
		record_size += *bind->field_length;
		++bind;
	}

	if ( Debug ) {
		(void) fprintf( stderr, end_msg, __func__, record_size, get_ctime() );
	}

	return record_size;
}
