/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function substitutes file name tags.
*/

char *_dfile_sub_tags( const char *fname, const dfile_tag_t *tag, unsigned short tag_cnt )
{
	char	file_path[PATH_MAX+1];
	char	*result;
	size_t	len;

	DEBUG_FUNC_START;

	len = strlen( fname );

	if ( len >= sizeof( file_path ) ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "file path [", stderr );
		(void) fputs( fname, stderr );
		(void) fputs( "] exceeds maximum length ", stderr );
		(void) fput_uint( sizeof( file_path ), stderr );
		(void) fputs( ".\n", stderr );
		RETURN_POINTER( (char *)0 );
	}

	(void) memcpy( (void *)file_path, (void *)fname, len + (size_t)1 );

	for ( ; tag_cnt > (unsigned short)0; --tag_cnt ) {
		if ( substitute_str( file_path, sizeof( file_path ), tag->tag, tag->tag_value ) == -1 ) {
			RETURN_POINTER( (char *)0 );
		}
		++tag;
	}

	result = strdup( file_path );
	if ( result == (char *)0 ) {
		UNIX_ERROR( "strdup() failed" );
		RETURN_POINTER( (char *)0 );
	}

	RETURN_POINTER( result );
}
