/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


#ifdef DFILE_THREAD

/*
** This function rotates and unlocks a buffer.
*/

int _dfile_release_buffer( dfile_buffer_t *buffer )
{
	int	ret;

	assert( buffer != (dfile_buffer_t *)0 );

	DEBUG_FUNC_START;

	if ( Debug ) {
		(void) fprintf( stderr, "Thread %u released buffer %hu.\n", pthread_self(), buffer->buffer_id );
	}

	buffer->state = buffer->state->next;

	buffer->thread_id = (pthread_t)0;
	ret = pthread_mutex_unlock( &buffer->mutex );
	if ( ret != 0 ) {
		THREAD_ERROR( "pthread_mutex_unlock() failed", ret );
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
#endif
