/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function allocates and initializes contents of a bind structure
** for each field.
*/

int _dfile_alloc_bind_fields( dfile_bind_t *bind_tbl, unsigned short bind_tbl_cnt )
{
	size_t	alloc_size, *field_length_ptr;
	const size_t	field_buffer_size = sizeof( char * );
	const size_t	field_length_size = sizeof( size_t );
	char	**field_buffer_ptr;
	unsigned short	ndx;

	assert( bind_tbl != (dfile_bind_t *)0 );
	assert( bind_tbl_cnt > (unsigned short)0 );

	DEBUG_FUNC_START;

	alloc_size = field_buffer_size * bind_tbl_cnt;
	field_buffer_ptr = (char **)malloc( alloc_size );
	if ( field_buffer_ptr == (char **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	alloc_size = field_length_size * bind_tbl_cnt;
	field_length_ptr = (size_t *)malloc( alloc_size );
	if ( field_length_ptr == (size_t *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	for ( ndx = (unsigned short)0; ndx < bind_tbl_cnt; ++ndx ) {
		bind_tbl->field_buffer = &field_buffer_ptr[ ndx ];
		bind_tbl->field_length = &field_length_ptr[ ndx ];
		*bind_tbl->field_buffer = "";
		*bind_tbl->field_length = (size_t)0;
		++bind_tbl;
	}

	RETURN_INT( 0 );
}
