/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function is called when a buffer becomes full. If only one buffer
** is being used, contents are immediately written. If more than one buffer
** is being used, the full buffer is passed to another thread.
*/

int _dfile_advance_buffer( dfile_t *dfile, dfile_buffer_t *buffer )
{
	assert( dfile != (dfile_t *)0 );
	assert( buffer != (dfile_buffer_t *)0 );

	DEBUG_FUNC_START;

	if ( Debug ) {
		(void) fprintf( stderr, "Application has filled buffer %hu.\n", buffer->buffer_id );
	}

#ifdef DFILE_THREAD
	if ( dfile->buffer_cnt == (unsigned short)1 ) {
#endif
		if ( ( *dfile->io_buffer_func )( dfile ) == -1 ) {
			RETURN_INT( -1 );
		}
#ifdef DFILE_THREAD
	} else {
		if ( _dfile_release_buffer( buffer ) == -1 ) {
			RETURN_INT( -1 );
		}

		buffer = buffer->next;
		dfile->application_buffer = buffer;

		if ( _dfile_buffer_wait( buffer, Dfile_format_state, dfile->buffer_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}
	}
#endif

	if ( dfile->error != Dfile_ok ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
