/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
 
/*
** Record layout:
**	1. GMT Time
**	2. Job Name
**	3. Step Name
**	4. Partition
**	5. Process ID
**	6. Action Code - S)tart, E)nd
**	7. Exit Code
**	8. Signal
*/
 
int main( int argc, char **argv )
{
	char	buf[512], msg[512], *log_name, *eos, date_fmt[12], time_fmt[12];
	time_t	gmt_int;
	struct tm	*tm;
	static char	*job_name, *step_name, *partition;
	static char	*gmt, *pid, *action_code, *exit_code, *end;
	static char	*signal_value;
	static char	**field_tbl[] = {
		&gmt, &job_name, &step_name, &partition,
		&pid, &action_code, &exit_code, &signal_value
	};
	const unsigned short	field_tbl_cnt = sizeof( field_tbl ) / sizeof( char ** );
	char	***field;
	unsigned short	ndx;
	size_t	len;
	unsigned long	rec_cnt = 0;
	const char	fs = '|';

	if ( argc != 2 ) {
		(void) fprintf( stderr, "usage: %s file\n", argv[ 0 ] );
		return 10;
	}
 
	log_name = argv[ 1 ];
 
	if ( strcmp( log_name, "-" ) != 0 ) {
		if ( freopen( log_name, "r", stdin ) == (FILE *)0 ) {
			(void) strcpy( msg, "Failed to open file [" );
			(void) strncat( msg, log_name, sizeof( msg ) - 35 );
			(void) strcat( msg, "]." );
			UNIX_ERROR( msg );
			return 20;
		}
	}

	(void) puts( "#DATE,TIME,JOB NAME,STEP NAME,PARTITION,PID,ACTION,EXIT CODE,SIGNAL" );
 
	while ( fgets( buf, sizeof( buf ), stdin ) != (char *)0 ) {
		++rec_cnt;
 
		len = strlen( buf );
		if ( len == (size_t)0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "File [", stderr );
			(void) fputs( log_name, stderr );
			(void) fputs( "] has zero length record, ", stderr );
			(void) fput_uint( rec_cnt, stderr );
			(void) fputs( ".\n", stderr );
			return 30;
		}
 
		if ( buf[ len - 1 ] != '\n' ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "File [", stderr );
			(void) fputs( log_name, stderr );
			(void) fputs( "] has record, ", stderr );
			(void) fput_uint( rec_cnt, stderr );
			(void) fputs( ", that is too long.\n", stderr );
			return 40;
		}
 
		--len;
		buf[ len ] = (char)0;
 
		end = &buf[ -1 ];
		field = field_tbl;
 
		for ( ndx = field_tbl_cnt; ndx > (unsigned short)1; --ndx ) {
			**field = &end[ 1 ];
			end = strchr( **field, fs );
			if ( end == (char *)0 ) {
				FPUT_SRC_CODE( stderr );
				(void) fputs( "File [", stderr );
				(void) fputs( log_name, stderr );
				(void) fputs( "] has record, ", stderr );
				(void) fput_uint( rec_cnt, stderr );
				(void) fputs( ", with incorrect number of fields.\n", stderr );
				return 50;
			}
			*end = (char)0;
			++field;
		}
 
		**field = &end[ 1 ];
 
		errno = 0;
 
		gmt_int = strtol( gmt, &eos, 10 );
 
		if ( eos == gmt || *eos != (char)0 || errno == ERANGE ) {
			(void) fprintf( stderr, "Could not convert UNIX date [%s] into an integer.\n", gmt );
			(void) strcpy( date_fmt, "  UNKNOWN DATE   " );
		} else {
			tm = localtime( &gmt_int );
			(void) snprintf( date_fmt, sizeof( date_fmt ), "%04d/%02d/%02d", tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday );
			(void) snprintf( time_fmt, sizeof( time_fmt ), "%02d:%02d:%02d", tm->tm_hour, tm->tm_min, tm->tm_sec );
		}
 
		switch ( *action_code ) {
		case 'S':
			action_code = "START";
			break;
		case 'E':
			action_code = "END";
			break;
		default:
			action_code = "UNKNOWN";
		}
 
#if 0
		(void) printf( "%s  %-10.10s  %s\n", date_fmt, job_name );
 
		(void) printf( "\t+ %-25.25s %-10.10s %10.10s %-5.5s %3.3s %3.3s\n", step_name, partition, pid, action_code, exit_code, signal_value );
#endif
		(void) printf( "%s,%s,%s,", date_fmt, time_fmt, job_name );
 
		(void) printf( "%s,%s,%s,%s,%s,%s\n", step_name, partition, pid, action_code, exit_code, signal_value );
	}
 
	if ( ferror( stdin ) || !feof( stdin ) ) {
		UNIX_ERROR( "fgets() failed" );
		return 60;
	}
 
	return 0;
}
 
