function load_field_names( field_file, field )
{
	getline_status = getline < field_file
	if ( getline_status < 0 ) {
		##
		## File does not exist.
		##
		return 0
	}

	field_cnt = 0
	while ( getline_status == 1 ) {
		if ( $0 ~ "^#" ) {
			continue
		}

		++field_cnt
		field[ field_cnt ] = $0

		getline_status = getline < field_file

		if ( getline_status < 0 ) {
			print "Failed reading field configuration file [" field_file "]." | "cat - >&2"
			exit 1
		}
	}

	close( field_file )
}

function find_dfile_entry( dfile_cfg, dfile_name )
{
	cfgdir_cnt = split( ENVIRON[ "CFGPATH" ], cfgdir, ":" )
	FS = ":"

	for ( cfgdir_ndx = 1; cfgdir_ndx <= cfgdir_cnt; ++cfgdir_ndx ) {
		cfgfile = cfgdir[ cfgdir_ndx ] "/dfile.cfg"

		getline_status = getline dfile_cfg < cfgfile

		if ( getline_status < 0 ) {
			##
			## File does not exist.
			##
			continue
		}

		while ( getline_status == 1 ) {
			if ( dfile_cfg[ 1 ] ~ "^#" ) {
				continue
			}
			if ( NF != 6 ) {
				continue
			}

			if ( dfile_name == dfile_cfg[ 1 ] ) {
				close( cfgfile )
				return
			}

			getline_status = getline dfile_cfg < cfgfile

			if ( getline_status < 0 ) {
				print "Failed reading configuration file [" cfgfile "]." | "cat - >&2"
				exit 1
			}
		}

		close( cfgfile )
	}

	print "DFILE [" dfile_name "] is not configured." | "cat - >&2"
}

BEGIN {
	dfile_read_cfg[ 1 ] = 1
	dfile_write_cfg[ 1 ] = 1
	dfile_read_field[ 1 ] = 1
	dfile_write_field[ 1 ] = 1

	find_dfile_entry( dfile_read_cfg, "address" )
	dfile_read_field_cnt = load_field_names( dfile_read_cfg[ 5 ], dfile_read_field )
	print dfile_read_cfg[ 2 ], dfile_read_cfg[ 3 ]
	for ( ndx = 1; ndx <= dfile_read_field_cnt; ++ndx ) {
		printf "\t%d. %s\n", ndx, dfile_read_field[ ndx ]
	}
}
