/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "where.h"
#include "dfile_utility.h"
#include "dfile_unique.h"


/*
** This function writes an output record.
*/
int output_record( dfile_t *dfile, void *output_filter )
{
	where_result_t	where_result;
	char	err_msg[ 256 ];

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	if ( output_filter == (void *)0 ) {
		/*
		** No output filter.
		*/
		if ( dfile_write( dfile ) == -1 ) {
			RETURN_INT( -1 );
		}
	} else {
		if ( where_condition( &where_result, err_msg, sizeof( err_msg ), output_filter ) != WHERE_NOERR ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "output where_condition() failed [", stderr );
			(void) fputs( err_msg, stderr );
			(void) fputs( "].\n", stderr );
			RETURN_INT( -1 );
		}

		if ( where_result == Where_result_true ) {
			if ( dfile_write( dfile ) == -1 ) {
				RETURN_INT( -1 );
			}
		}
	}

	RETURN_INT( 0 );
}
