/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


static int cmp( const void *, const void * );
static void dump( field_t **, unsigned long, unsigned short );

static order_by_t	*key_tbl;
static unsigned short		*key_ndx_tbl;
static unsigned short		key_tbl_cnt;

/*
** This function sorts records.
*/
int sort_records( field_t **rec, unsigned long rec_cnt, order_by_t *ikey_tbl, unsigned short *ikey_ndx_tbl, unsigned short ikey_tbl_cnt, char sort_algorithm )
{
	int	ret;

	assert( ikey_tbl != (order_by_t *)0 );
	assert( ikey_ndx_tbl != (unsigned short *)0 );

	DEBUG_FUNC_START;

	if ( rec_cnt < 2UL ) {
		/*
		** Nothing to sort.
		*/
		RETURN_INT( 0 );
	}
#if 0
dump( rec, rec_cnt, *ikey_ndx_tbl );
#endif

	key_tbl = ikey_tbl;
	key_ndx_tbl = ikey_ndx_tbl;
	key_tbl_cnt = ikey_tbl_cnt;

	switch ( sort_algorithm ) {
	case 'H':
	case 'h':
		ret = heap_sort( (void *)rec, (size_t)rec_cnt, sizeof( field_t * ), cmp );
		break;

	case 'I':
	case 'i':
		ret = insertion_sort( (void *)rec, (size_t)rec_cnt, sizeof( field_t * ), cmp );
		break;

	case 'M':
	case 'm':
		ret = merge_sort( (void *)rec, (size_t)rec_cnt, sizeof( field_t * ), cmp );
		break;

	case 'Q':
	case 'q':
		qsort( (void *)rec, (size_t)rec_cnt, sizeof( field_t * ), cmp );
		ret = 0;
		break;

	case 'S':
	case 's':
		ret = shell_sort( (void *)rec, (size_t)rec_cnt, sizeof( field_t * ), cmp );
		break;

	default:
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Unknown sort algorithm [", stderr );
		(void) fputc( sort_algorithm, stderr );
		(void) fputs( "]--expected H, I, M, Q or S.\n", stderr );
		ret = -1;
	}
#if 0
dump( rec, rec_cnt, *ikey_ndx_tbl );
#endif

	RETURN_INT( ret );
}

static int cmp( const void *x, const void *y )
{
	const field_t	*lhs_field, *rhs_field, *lhs_field_tbl, *rhs_field_tbl;
	order_by_t	*key;
	unsigned short	offset, ndx, *key_ndx;
	int	result;

	assert( x != (const void *)0 );
	assert( y != (const void *)0 );

	lhs_field_tbl = *(const field_t **)x;
	rhs_field_tbl = *(const field_t **)y;

	assert( lhs_field_tbl != (const field_t *)0 );
	assert( rhs_field_tbl != (const field_t *)0 );

	key = key_tbl;
	key_ndx = key_ndx_tbl;

	for ( ndx = key_tbl_cnt; ndx > (unsigned short)0; --ndx ) {
		offset = *key_ndx;
		lhs_field = &lhs_field_tbl[ offset ];
		rhs_field = &rhs_field_tbl[ offset ];

		result = compare( lhs_field->value, lhs_field->length, rhs_field->value, rhs_field->length, key->value_type, key->ascend_descend );

		if ( result != 0 ) {
			return result;
		}
		++key;
		++key_ndx;
	}

	return 0;
}

static void dump( field_t **rec, unsigned long rec_cnt, unsigned short ndx )
{
	field_t	*field;

	while ( rec_cnt > 0UL ) {
		field = *rec;
		fprintf( stderr, "dump [%*.*s]\n", field[ndx].length, field[ndx].length, field[ ndx ].value );
		++rec;
		--rec_cnt;
	}
}
