/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */


typedef struct {
	char	*field_name;
	char	ascend_descend;	/* (A)scend or (D)escend */
	char	value_type;	/* (A)SCII, (N)umeric, or (H)igh value nulls */
	int	(*cmp)( const void *, size_t, const void *, size_t );
} order_by_t;

typedef struct {
	const char	*dfile_name;
	dfile_tag_t	*tag;
	unsigned short	tag_cnt;
	unsigned short	blocks_per_buffer_cnt;
	unsigned short	buffer_cnt;
	sexpr_t		*where;
} sm_dfile_t;

typedef struct {
	const char	*dfile_name;
	dfile_tag_t	*tag;
	unsigned short	tag_cnt;
	unsigned short	blocks_per_buffer_cnt;
	unsigned short	buffer_cnt;
	dfile_open_mode_t	dfile_open_mode;
} output_t;

typedef struct merge_queue_s	merge_queue_t;

struct merge_queue_s {
	dfile_t	*dfile;
	void	*where;
	unsigned short	*io_field_map;
	unsigned short	*key_ndx_tbl;
	merge_queue_t	*next;
};

int get_args( int, char * const [], const char **, const char **, int *, int *, dfile_tag_t **, unsigned short *, const char **, char *, const char **, const char ** );
int parse_one_key( order_by_t *, const char *, const char * );
int parse_key_argument( order_by_t **, unsigned short *, const char * );
int open_input( dfile_t **, const char *, dfile_tag_t *, unsigned short, unsigned short, unsigned short );
int assign_order_by_field_offset( unsigned short **, order_by_t *, unsigned short, dfile_bind_t *, unsigned short, dfile_bind_t ** );
int copy_sort_record( field_t **, dfile_bind_t *, unsigned short, unsigned short *, unsigned short );
int sort_records( field_t **, unsigned long, order_by_t *, unsigned short *, unsigned short, char );
int open_output( dfile_t **, const char *, dfile_tag_t *, unsigned short, int, output_t * );
int map_io_fields( unsigned short **, dfile_bind_t **, dfile_bind_t *, unsigned short, dfile_bind_t **, dfile_bind_t *, unsigned short, unsigned short *, unsigned short, const char * );
int merge_records( dfile_t *, field_t **, unsigned long, const order_by_t *, const unsigned short *, unsigned short, merge_queue_t * );
int numeric_cmp( const char *, const char * );
int high_value_null_cmp( const char *, size_t, const char *, size_t );
int open_merge_input( dfile_t ***, const char *, dfile_tag_t *, unsigned short, int, sm_dfile_t **, unsigned short * );
int validate_consistent_bind( dfile_bind_t *, unsigned short, dfile_bind_t *, unsigned short );
void copy_record_to_bind( dfile_bind_t *, unsigned short, field_t * );
int write_sorted_records( dfile_t *, field_t **, unsigned long );
int compare( const char *, size_t, const char *, size_t, char, char );
int map_merge_fields( unsigned short ***, unsigned short ***, dfile_t **, unsigned short, dfile_bind_t **, dfile_bind_t *, unsigned short, order_by_t *, unsigned short );
int create_merge_queue( merge_queue_t **, dfile_t **, unsigned short, unsigned short **, order_by_t *, unsigned short **, unsigned short, sm_dfile_t * );
int compare_order_by_bind( dfile_bind_t *, const unsigned short *, dfile_bind_t *, const unsigned short *, const order_by_t *, unsigned short );
int add_to_merge_queue( merge_queue_t **, merge_queue_t *, const order_by_t *, unsigned short );
int compare_sort_field_bind( const field_t *, const order_by_t *, const unsigned short *, const dfile_bind_t *, const unsigned short *, unsigned short );
void control_syntax_error( const char *, const char *, int, unsigned short );
int assign_control_information( order_by_t **, unsigned short *, sm_dfile_t **, unsigned short *, char *, sm_dfile_t **, unsigned short *, output_t *, const char * );
int level1_syntax( order_by_t **, unsigned short *, sm_dfile_t **, unsigned short *, char *, sm_dfile_t **, unsigned short *, output_t *, sexpr_t *, unsigned short );
int assign_order_by( order_by_t **, unsigned short *, sexpr_t *, unsigned short );
int assign_field_attribute( order_by_t *, sexpr_t *, unsigned short );
int assign_sort( sm_dfile_t **, unsigned short *, char *, sexpr_t *, unsigned short );
int assign_sort_dfile( sm_dfile_t *, sexpr_t *, unsigned short );
int assign_sort_dfile_attribute( sm_dfile_t *, sexpr_t *, unsigned short );
int assign_tag( dfile_tag_t **, unsigned short *, sexpr_t *, unsigned short );
int assign_algorithm( char *, sexpr_t *, unsigned short );
int assign_output( output_t *, sexpr_t *, unsigned short );
int assign_output_dfile( output_t *, sexpr_t *, unsigned short );
int assign_ushort( unsigned short *, sexpr_t *, unsigned short );
int assign_open_mode( dfile_open_mode_t *, sexpr_t *, unsigned short );
int load_sort( field_t ***, unsigned long *, const char *, dfile_tag_t *, unsigned short, int, sm_dfile_t *, unsigned short, dfile_bind_t **, dfile_bind_t *, unsigned short, unsigned short *, unsigned short );
int assign_output_dfile_attribute( output_t *, sexpr_t *, unsigned short );
int merge_write( dfile_t *, merge_queue_t **, const order_by_t *, unsigned short );

#define	CONTROL_SYNTAX_ERROR( m, t )	control_syntax_error( m, __FILE__, __LINE__, t )
