/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_sort.h"


/*
** This function assigns information from control structure.
*/
int assign_open_mode( dfile_open_mode_t *result, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	assert( result != (dfile_open_mode_t *)0 );
	assert( sexpr != (sexpr_t *)0 );

	DEBUG_FUNC_START;

	if ( SEXPR_CAR_TYPE( sexpr ) != string_sexpr ) {
		control_syntax_error( "expected a string", __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	if ( strcasecmp( SEXPR_CAR_STRING( sexpr ), "truncate" ) == 0 ) {
		*result = Dfile_trunc;
	} else {
		if ( strcasecmp( SEXPR_CAR_STRING( sexpr ), "append" ) == 0 ) {
			*result = Dfile_append;
		} else {
			CONTROL_SYNTAX_ERROR( "expected open-mode to be truncate or append", tuple_cnt );
			RETURN_INT( -1 );
		}
	}

	if ( Debug ) {
		(void) fprintf( stderr, "open-mode is [%s]\n", SEXPR_CAR_STRING( sexpr ) );
	}

	RETURN_INT( 0 );
}
