/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"


/*
** This function is used to remap field names.
*/
void find_field_alias( char **alias, const char *field_name, map_field_t *map_field_tbl, unsigned short map_field_tbl_cnt, const char *source, const char *target )
{

	assert( alias != (char **)0 );
	assert( field_name != (const char *)0 );
	assert( source != (const char *)0 );
	assert( target != (const char *)0 );

	DEBUG_FUNC_START;

	*alias = (char *)0;

	for ( ; map_field_tbl_cnt > (unsigned short)0; --map_field_tbl_cnt ) {
		if ( strcasecmp( map_field_tbl->field[ 0 ].direction, source ) == 0 && strcasecmp( map_field_tbl->field[ 1 ].direction, target ) == 0 && strcasecmp( map_field_tbl->field[ 0 ].field_name, field_name ) == 0 )  {
			*alias = map_field_tbl->field[ 1 ].field_name;
			break;
		}

		if ( strcasecmp( map_field_tbl->field[ 1 ].direction, source ) == 0 && strcasecmp( map_field_tbl->field[ 0 ].direction, target ) == 0 && strcasecmp( map_field_tbl->field[ 1 ].field_name, field_name ) == 0 )  {
			*alias = map_field_tbl->field[ 0 ].field_name;
			break;
		}

		++map_field_tbl;
	}


	if ( Debug ) {
		if ( *alias == (char *)0 ) {
			(void) fprintf( stderr, "no alias found for field [%s]\n", field_name );
		} else {
			(void) fprintf( stderr, "field [%s] is being aliased to [%s]\n", field_name, *alias );
		}
	}

	RETURN_VOID;
}
