/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"

/*
** This function sets environment variables.
*/
int set_env_var( char **env_var, unsigned short env_var_cnt )
{
	char	*expanded_str, *new_str;

	DEBUG_FUNC_START;

	for ( ; env_var_cnt > (unsigned short)0; --env_var_cnt ) {
		expanded_str = strenv( *env_var );
		if ( expanded_str == (char *)0 ) {
			RETURN_INT( -1 );
		}

		new_str = strdup( expanded_str );
		if ( new_str == (char *)0 ) {
			UNIX_ERROR( "strdup() failed" );
			RETURN_INT( -1 );
		}

		if ( Debug ) {
			(void) fprintf( stderr, "setenv: [%s]\n", new_str );
		}

		if ( putenv( new_str ) != 0 ) {
			UNIX_ERROR( "Failed to create environment variable." );
			RETURN_INT( -1 );
		}
		++env_var;
	}

	RETURN_INT( 0 );
}
