/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <sys/resource.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <tbox.h>
#include "sexpr.h"
#include "dfile_exec.h"


/*
** This program is used to run groups of data files concurrently.
*/
int main( int argc, char **argv )
{
	const char	*job_name;
	const char	*recovery_log, *control_fname;
	int	log_fd;
	step_t	*step;
	unsigned short	step_cnt;
	time_t	prev_utime = 0, prev_stime = 0, prev_rtime, gmt;
	struct rusage	r_usage;
	completed_t	*completed;
	unsigned long	completed_cnt;
	char	**env_var;
	unsigned short	env_var_cnt;

	setbuf( stdout, (char *)0 );

	/*
	** Process command line arguments.
	*/
	if ( get_args( argc, argv, &recovery_log, &control_fname ) == -1 ) {
		return 10;
	}

#if 0
Debug = 1;
#endif
	DEBUG_FUNC_START;

	if ( assign_job( &job_name, &step, &step_cnt, &env_var, &env_var_cnt, control_fname ) == -1 ) {
		RETURN_INT( 20 );
	}

	if ( load_completed( &completed, &completed_cnt, recovery_log, job_name ) == -1 ) {
		RETURN_INT( 25 );
	}

	log_fd = open_log_file( recovery_log );
	if ( log_fd < 0 ) {
		RETURN_INT( 30 );
	}

	if ( set_env_var( env_var, env_var_cnt ) == -1 ) {
		RETURN_INT( 32 );
	}

	(void) time( &prev_rtime );

	for ( ; step_cnt > (unsigned short)0; --step_cnt ) {
		if ( process_step( step, completed, completed_cnt, log_fd, job_name ) == -1 ) {
			RETURN_INT( 35 );
		}
		if ( getrusage( RUSAGE_CHILDREN, &r_usage ) == -1 ) {
			UNIX_ERROR( "getrusage() failed" );
			RETURN_INT( 40 );
		}

		(void) time( &gmt );

		write_system_usage( step->step_name, r_usage.ru_utime.tv_sec - prev_utime, r_usage.ru_stime.tv_sec - prev_stime, gmt - prev_rtime );

		prev_utime = r_usage.ru_utime.tv_sec;
		prev_stime = r_usage.ru_stime.tv_sec;
		prev_rtime = gmt;
		++step;
	}

	RETURN_INT( 0 );
}
