/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


static void		print_usage( const char * );

/*
** This function processes the command line arguments.
*/
int get_args( int argc, char * const argv[], const char **recovery_log, const char **control_fname )
{
	int	ch;
	extern char	*optarg;

	assert( argv != (char **) 0 );
	assert( recovery_log != (const char **) 0 );
	assert( control_fname != (const char **) 0 );

#ifndef NDEBUG
	/*
	** Initialize debug to off.
	*/
	Debug = 0;
#endif

	/*
	** Initialize return values.
	*/
	*recovery_log = (const char *)0;
	*control_fname = (const char *)0;

	while ( ( ch = getopt( argc, argv, "c:dl:" ) ) != EOF ) {
		switch ( ch ) {
		case 'c':
			*control_fname = optarg;
			break;
		case 'd':
#ifdef NDEBUG
			(void) fputs( "Not compiled for debug.\n", stderr );
#else
			Debug = 1;
#endif
			break;
		case 'l':
			*recovery_log = optarg;
			break;
		default:
			print_usage( argv[ 0 ] );
			return -1;
		}
	}

	if ( *control_fname == (const char *)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Control file name must be specified.\n", stderr );
		print_usage( argv[ 0 ] );
		return -1;
	}

	if ( Debug ) {
		(void) fprintf( stderr, "control file [%s]\n", ( *control_fname == (const char *)0 ) ? "NULL" : *control_fname );
		(void) fprintf( stderr, "Recovery log [%s]\n", ( *recovery_log == (const char *)0 ) ? "NULL" : *recovery_log );
	}

	return 0;
}

static void print_usage( const char *exec_name )
{
	(void) fputs( "usage: ", stderr );
	(void) fputs( exec_name, stderr );
	(void) fputs( " [-d]", stderr );
	(void) fputs( " [-c file]", stderr );
	(void) fputs( " [-l file]", stderr );
	(void) fputc( '\n', stderr );
	(void) fputs( "\t-d -> debug (optional)\n", stderr );
	(void) fputs( "\t-c -> control file (optional)\n", stderr );
	(void) fputs( "\t-l -> recovery log (optional)\n", stderr );
}
