/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <search.h>
#include <assert.h>
#include "tbox.h"
#include "rbtree.h"
#include "sexpr.h"
#include "dfile_exec.h"

/*
** This function builds and parses commands to execute.
*/
int assign_exec_args( char ***result_arg, char ***result_env_var, char **exec_arg, unsigned short exec_arg_cnt, char **env_var, unsigned short env_var_cnt, const char *divvy_text, unsigned short divvy_ndx )
{
	char	**arg, **ptr, **new_env_var;
	char	sequence[24];

	assert( result_arg != (char ***)0 );
	assert( result_env_var != (char ***)0 );
	assert( exec_arg != (char **)0 );
	/*
	** divvy_text will be null.
	*/

	DEBUG_FUNC_START;

	/*
	** Search command line arguments for %n and %s flags.
	** These flags are replaced with slice sequence number
	** and partition name respectively.
	*/
	if ( snprintf( sequence, sizeof( sequence ), "%hu", divvy_ndx ) <= 0 ) {
		UNIX_ERROR( "sprintf() failed to convert proc_ndx to ASCII" );
		RETURN_INT( -1 );
	}


	/*
	** Process command line arguments.
	*/
	if ( copy_exec_args( &arg, exec_arg, exec_arg_cnt ) == -1 ) {
		RETURN_INT( -1 );
	}

	for ( ptr = arg; *ptr != (char *)0; ++ptr ) {
		/*
		** Replace %n and %s flags that occur in command.
		*/
		if ( substitute_tokens( ptr, sequence, divvy_text ) == -1 ) {
			RETURN_INT( -1 );
		}
	}


	/*
	** Process environment variables.
	*/
	if ( env_var_cnt == (unsigned short)0 ) {
		new_env_var = (char **)0;
	} else {
		if ( copy_exec_args( &new_env_var, env_var, env_var_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}

		for ( ptr = new_env_var; *ptr != (char *)0; ++ptr ) {
			/*
			** Replace %n and %s flags that occur in command.
			*/
			if ( substitute_tokens( ptr, sequence, divvy_text ) == -1 ) {
				RETURN_INT( -1 );
			}
		}
	}

	*result_arg = arg;
	*result_env_var = new_env_var;

	RETURN_INT( 0 );
}
