/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


/*
** This function assigns information from control structure.
*/
int assign_exec( char ***exec_arg, unsigned short *exec_arg_cnt, sexpr_t *field, unsigned short tuple_cnt )
{
	char	**new = 0;
	unsigned short	cnt = 0;
	size_t	alloc_size;

	assert( exec_arg != (char ***)0 );
	assert( exec_arg_cnt != (unsigned short *)0 );

	DEBUG_FUNC_START;

	while ( field != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( field ) != string_sexpr ) {
			CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
			RETURN_INT( -1 );
		}

		alloc_size = ( cnt + (unsigned short)1 ) * sizeof( char * );
		new = (char **)realloc( new, alloc_size );

		if ( new == (char **)0 ) {
			UNIX_ERROR( "realloc() failed" );
			RETURN_INT( -1 );
		}

		new[ cnt ] = SEXPR_CAR_STRING( field );

		++cnt;

		assert( SEXPR_CDR_TYPE( field ) == list_sexpr );

		field = SEXPR_CDR_LIST( field );
	}

	*exec_arg = new;
	*exec_arg_cnt = cnt;

	RETURN_INT( 0 );
}
