/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_dynamic.h"
#include "sexpr.h"
#include "where.h"
#include "dfile_diff.h"


/*
** This function opens a data file for reading.
*/
int prepare_input_dfile( input_dfile_t *input_dfile, dfile_tag_t *tag_tbl, unsigned short tag_tbl_cnt, char **key_field_tbl, unsigned short key_field_tbl_cnt, const char *filter_file_name )
{
	sexpr_t	*sexpr;
	int	result;
	char	err_msg[256];

	assert( input_dfile != (input_dfile_t *)0 );
	assert( key_field_tbl != (char **)0 );

	DEBUG_FUNC_START;

	if ( open_input_dfile( &input_dfile->dfile, input_dfile->dfile_name, tag_tbl, tag_tbl_cnt ) == -1 ) {
		RETURN_INT( -1 );
	}

	if ( assign_field_bind( &input_dfile->key_bind_tbl, key_field_tbl, key_field_tbl_cnt, input_dfile->dfile->sorted_bind, input_dfile->dfile->bind_cnt ) == -1 ) {
		RETURN_INT( -1 );
	}

	if ( filter_file_name != (const char *)0 ) {
		result = sexpr_load( &sexpr, filter_file_name );

		if ( result != 0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "failed to load s-expression record filter from file [", stderr );
			(void) fputs( filter_file_name, stderr );
			(void) fputs( "]: [", stderr );
			(void) fputs( sexpr_error( result ), stderr );
			(void) fputs( "]\n", stderr );
			return -1;
		}

		if ( where_compile_sexpr( &input_dfile->where, err_msg, sizeof( err_msg ), (void *)sexpr, input_dfile->dfile ) != WHERE_NOERR ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "where_compile_sexpr() failed for joining dfile [", stderr );
			(void) fputs( input_dfile->dfile_name, stderr );
			(void) fputs( "]\n\t+ [", stderr );
			(void) fputs( err_msg, stderr );
			(void) fputs( "].\n", stderr );
			RETURN_INT( -1 );
		}
	}

	RETURN_INT( 0 );
}
