/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <limits.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_dynamic.h"
#include "sexpr.h"
#include "where.h"
#include "dfile_diff.h"


/*
*/
void copy_input_to_output( dfile_bind_t *output, dfile_bind_t *input, unsigned short *map_tbl, unsigned short map_tbl_cnt )
{
	dfile_bind_t	*bind;

	assert( output != (dfile_bind_t *)0 );
	assert( input != (dfile_bind_t *)0 );
	assert( map_tbl != (unsigned short *)0 );
	assert( map_tbl_cnt > (unsigned short)0 );

	DEBUG_FUNC_START;

	for ( ; map_tbl_cnt > (unsigned short)0; --map_tbl_cnt ) {
		if ( *map_tbl == USHRT_MAX ) {
			/*
			** No input field mapped to output.
			*/
			*output->field_buffer = "";
			*output->field_length = (size_t)0;
		} else {
			bind = &input[ *map_tbl ];
			*output->field_buffer = *bind->field_buffer;
			*output->field_length = *bind->field_length;
		}

		++map_tbl;
		++output;
	}

	RETURN_VOID; 
}
