/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_dynamic.h"
#include "sexpr.h"
#include "where.h"
#include "dfile_diff.h"

/*
*/
int compare_non_key_data( int *cmp_result, change_data_t *change_data, dfile_t *change_data_dfile, dfile_bind_t *bind, unsigned short bind_cnt, dfile_bind_t **non_key_bind_tbl )
{
	dfile_bind_t	*other_bind;
	int	cmp = 0;

	assert( cmp_result != (int *)0 );
	assert( bind != (dfile_bind_t *)0 );
	assert( bind_cnt > (unsigned short)0 );
	assert( non_key_bind_tbl != (dfile_bind_t **)0 );

	DEBUG_FUNC_START;

	*cmp_result = 0;

	for ( ; bind_cnt > (unsigned short)0; --bind_cnt ) {
		if ( *non_key_bind_tbl == (dfile_bind_t *)0 ) {
			/*
			** Key field or field that does not map.
			*/
			++bind;
			++non_key_bind_tbl;
			continue;
		}

		other_bind = *non_key_bind_tbl;

		cmp = strnncmp( *bind->field_buffer, *bind->field_length, *other_bind->field_buffer, *other_bind->field_length );

		if ( cmp != 0 ) {
			*cmp_result = 1;
			if ( change_data_dfile != (dfile_t *)0 ) {
				assert( change_data != (change_data_t *)0 );

				change_data->field_name = bind->field_name;
				change_data->field_name_len = strlen( bind->field_name );
				change_data->original_value = *bind->field_buffer;
				change_data->original_value_len = *bind->field_length;
				change_data->subsequent_value = *other_bind->field_buffer;
				change_data->subsequent_value_len = *other_bind->field_length;
				if ( dfile_write( change_data_dfile ) == -1 ) {
					RETURN_INT( -1 );
				}
			}
		}

		++bind;
		++non_key_bind_tbl;
	}

	RETURN_INT( 0 );
}
