/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_agfunc.h"


/*
** This function parses and validates average and sum field lists.
*/
int parse_avg_sum_field_list( const char **src_field, const char **result_field, const char **output_format, const char *field_list )
{
	char	**list;
	unsigned long	list_cnt;
	const char	delimiter = ',';

	assert( src_field != (const char **)0 );
	assert( result_field != (const char **)0 );
	assert( output_format != (const char **)0 );
	assert( field_list != (const char *)0 );

	DEBUG_FUNC_START;

	if ( parse_list( &list, &list_cnt, field_list, delimiter ) == -1 ) {
		return -1;
	}

	if ( list_cnt < 2UL || list_cnt > 3UL ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Expected list [", stderr );
		(void) fputs( field_list, stderr );
		(void) fputs( "] to contain two fields names and optional output format.\n", stderr );
		return -1;
	}

	*src_field = (const char *)list[ 0 ];
	*result_field = (const char *)list[ 1 ];

	if ( list_cnt == 2UL ) {
		/*
		** Default output format to %g.
		*/
		*output_format = "%g";
	} else {
		*output_format = (const char *)list[ 2 ];
	}

	return 0;
}
