/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_agfunc.h"


static int bind_field( dfile_bind_t **, dfile_bind_t **, unsigned short, const char *, const char * );

/*
** This function binds field names used in aggregate functions to dfile.
*/
int bind_func( func_t *func_ptr, unsigned short func_cnt, dfile_bind_t **input_sorted_bind, unsigned short input_sorted_bind_cnt, dfile_bind_t **output_sorted_bind, unsigned short output_sorted_bind_cnt )
{

	assert( func_ptr != (func_t *)0 );
	assert( input_sorted_bind != (dfile_bind_t **)0 );
	assert( output_sorted_bind != (dfile_bind_t **)0 );

	DEBUG_FUNC_START;

	for ( ; func_cnt > (unsigned short)0; --func_cnt ) {
		if ( func_ptr->src_field_name != (const char *)0 ) {
			if ( bind_field( &func_ptr->src_bind, input_sorted_bind, input_sorted_bind_cnt, func_ptr->src_field_name, "Input" ) == -1 ) {
				RETURN_INT( -1 );
			}
		}

		if ( bind_field( &func_ptr->result_bind, output_sorted_bind, output_sorted_bind_cnt, func_ptr->result_field_name, "Output" ) == -1 ) {
			RETURN_INT( -1 );
		}

		++func_ptr;
	}

	RETURN_INT( 0 );
}

static int bind_field( dfile_bind_t **result, dfile_bind_t **sorted_bind, unsigned short sorted_bind_cnt, const char *field_name, const char *desc )
{
	dfile_bind_t	**bind_entry, *key, key_bind;

	key_bind.field_name = (char *)field_name;
	key = &key_bind;

	bind_entry = (dfile_bind_t **)bsearch( (void *)&key, (void *)sorted_bind, (size_t)sorted_bind_cnt, sizeof( dfile_bind_t * ), dfile_bind_field_name_cmp );
	if ( bind_entry == (dfile_bind_t **)0 ) {
		fput_src_code( __FILE__, __LINE__, stderr );
		(void) fputs( desc, stderr );
		(void) fputs( " field [", stderr );
		(void) fputs( field_name, stderr );
		(void) fputs( "] was not defined.\n", stderr );
		return -1;
	}

	*result = *bind_entry;

	return 0;
}
