## Copyright (C) 2009, 2010, 2011, 2012 Keith Crane
## 
## This file is part DFILE Tools.
## 
## DFILE Tools is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or (at
## your option) any later version.
## 
## DFILE Tools is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
## or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
## for more details.
## 
## You should have received a copy of the GNU General Public License along
## with DFILE Tools; see the file COPYING.  If not, see
## <http://www.gnu.org/licenses/>.
## 

for dir in lib bin
do
	if [ ! -d ${dir} ]
	then
		mkdir ${dir}
		if [ $? -ne 0 ]
		then
			echo Failed to mkdir ${dir}. >&2
			exit 10
		fi
	fi
done

while read libdir libname
do
	echo ${libname}
	cd ${libdir}
	if [ $? -ne 0 ]
	then
		echo Failed to cd to ${libdir}. >&2
		exit 1
	fi
	make
	if [ $? -ne 0 ]
	then
		echo Failed to make in ${libdir}. >&2
		exit 2
	fi
	mv ${libname}.a ../lib
	if [ $? -ne 0 ]
	then
		echo Failed to mv ${libname}.a to ../lib. >&2
		exit 3
	fi
	make clean
	cd -
done <<!
libtbox		libtbox
libdfile	libdfile
libsexpr	libsexpr
libwhere	libwhere
libdfile_dynamic	libdfile_dynamic
libdfile_utility	libdfile_utility
!

while read progdir progname
do
	echo ${progname}
	cd ${progdir}
	if [ $? -ne 0 ]
	then
		echo Failed to cd to ${progdir}. >&2
		exit 5
	fi
	make
	if [ $? -ne 0 ]
	then
		echo Failed to make in ${progdir}. >&2
		exit 6
	fi
	mv ${progname} ../bin
	if [ $? -ne 0 ]
	then
		echo Failed to mv ${progname} to ../bin. >&2
		exit 7
	fi
	make clean
	cd -
done <<!
dcat		dcat
dfile_agfunc	dfile_agfunc
dfile_exec	dfile_exec
dfile_join	dfile_join
dfile_partition	dfile_partition
dfile_sort	dfile_sort
dfile_unique	dfile_unique
exec_log	exec_log
dfile_cache_create	dfile_cache_create
dfile_transform	dfile_transform	
dfile_diff	dfile_diff
fixed2dfile	fixed2dfile
nsplit		nsplit
!
