/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <assert.h>
#include "tbox.h"


int str_to_unix_time( time_t *gmt, const char *date )
{
	struct tm	ctm;
	char		buf[24];

	assert( gmt != (time_t *)0 );
	assert( date != (const char *)0 );

	if ( Debug ) {
		(void) fprintf( stderr, "%s( [%p], [%s] )\n", __func__, (void *)gmt, date );
	}

	DEBUG_FUNC_START;

	if ( strlen( date ) != (size_t) 8 ) {
		(void) fputs( __FILE__, stderr );
		(void) fprintf( stderr, "(%d)", __LINE__ );
		(void) fputs( ": Date [", stderr );
		(void) fputs( date, stderr );
		(void) fputs( "] was not in the expected format YYYYMMDD.\n", stderr );
		RETURN_INT( -1 );
	}

	(void) strncpy( buf, date, 4 );
	buf[ 4 ] = (char) 0;
	ctm.tm_year = atoi( buf ) - 1900;

	(void) strncpy( buf, &date[ 4 ], 2 );
	buf[ 2 ] = (char) 0;
	ctm.tm_mon = atoi( buf ) - 1;

	(void) strncpy( buf, &date[ 6 ], 2 );
	buf[ 2 ] = (char) 0;
	ctm.tm_mday = atoi( buf );

	ctm.tm_hour = 0;
	ctm.tm_min = 0;
	ctm.tm_sec = 0;
	ctm.tm_isdst = 0;

	*gmt = mktime( &ctm );

	if ( Debug ) {
		(void) fprintf( stderr, "gmt = %ld\n", (long)*gmt );
	}

	RETURN_INT( 0 );
}
