/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"


int _sexpr_assign_car( sexpr_value_t *sexpr_value, int *ret_end_of_list_flag, const char **str, unsigned long depth )
{
	const char	*string_value, *string_end;
	char	ch;
	int	end_of_list_flag, ret;

	assert( sexpr_value != (sexpr_value_t *)0 );
	assert( ret_end_of_list_flag != (int *)0 );
	assert( str != (const char **)0 );

	DEBUG_FUNC_START;

	/*
	** Initialize end of list flag to false.
	*/
	*ret_end_of_list_flag = 0;

	ch = **str;
	while ( ch != (char)0 && ( ch == ' ' || ch == '\n' || ch == '\t' ) ) {
		/*
		** Chew up leading white space.
		*/
		++*str;
		ch = **str;
	}

	if ( ch == (char)0 ) {
		/*
		** Unexpected end of expression.
		*/
		RETURN_INT( SEXPR_EOEXPR );
	}

	/*
	** Assign CAR.
	*/
	switch ( ch ) {
	case '"':
		if ( Debug ) {
			(void) fputs( "found quote character\n", stderr );
		}

		++*str;

		string_value = *str;
		ret = _sexpr_find_end_of_string( &string_end, *str, "\"" );
		if ( ret != 0 ) {
			RETURN_INT( ret );
		}

		if ( _sexpr_create_string_value( sexpr_value, string_value, string_end ) == -1 ) {
			RETURN_INT( -1 );
		}

		*str = string_end + 1;
		break;

	case ')':
		if ( Debug ) {
			(void) fputs( "found right parenthesis\n", stderr );
		}

		++*str;

		/*
		** Set end of list flag to true.
		*/
		*ret_end_of_list_flag = 1;

		RETURN_INT( 0 );

	case '(':
		if ( Debug ) {
			(void) fputs( "found left parenthesis\n", stderr );
		}

		++*str;

		sexpr_value->type = list_sexpr;

		ret = _sexpr_parse_pair( &sexpr_value->value_u.list, &end_of_list_flag, str, depth + 1UL );
		if ( ret != 0 ) {
			RETURN_INT( ret );
		}

		break;

	default:
		if ( Debug ) {
			(void) fputs( "found unquoted string\n", stderr );
		}

		string_value = *str;
		ret = _sexpr_find_end_of_string( &string_end, *str, " ()\n\t" );
		if ( ret != 0 ) {
			RETURN_INT( ret );
		}

		if ( _sexpr_create_string_value( sexpr_value, string_value, string_end ) == -1 ) {
			RETURN_INT( -1 );
		}

		*str = string_end;
	}

	ret = 0;

	RETURN_INT( ret );
}
