/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"


/*
** This function compares key fields between two bind structures.
*/
int compare_bind( const dfile_bind_t **lhs_bind, const dfile_bind_t **rhs_bind, unsigned short key_tbl_cnt )
{
	int	result;
	const dfile_bind_t	*lhs, *rhs;

	assert( lhs_bind != (const dfile_bind_t **)0 );
	assert( rhs_bind != (const dfile_bind_t **)0 );

	DEBUG_FUNC_START;

	for ( ; key_tbl_cnt > (unsigned short)0; --key_tbl_cnt ) {
		lhs = *lhs_bind;
		rhs = *rhs_bind;
		result = strnncmp( *lhs->field_buffer, *lhs->field_length, *rhs->field_buffer, *rhs->field_length );

		if ( result != 0 ) {
			RETURN_INT( result );
		}

		++lhs_bind;
		++rhs_bind;
	}

	RETURN_INT( 0 );
}
