/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function validates function arguments to dfile_read_open() and
** dfile_write_open().
*/

int _dfile_vdate_rwopen_args( const dfile_cfg_t *cfg, const dfile_bind_t *bind, unsigned short bind_cnt, unsigned short buffer_block_cnt, unsigned short buffer_cnt )
{
	int	fatal_error_flag;

	DEBUG_FUNC_START;

	/*
	** Validate function arguments.
	*/
	if ( cfg == (const dfile_cfg_t *)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "dfile_cfg_t pointer argument was null.\n", stderr );
		RETURN_INT( -1 );
	}

	/*
	** Set fatal error flag to false.
	*/
	fatal_error_flag = 0;

	if ( ( bind != (const dfile_bind_t *)0 && bind_cnt == (unsigned short)0 ) || ( bind == (const dfile_bind_t *)0 && bind_cnt != (unsigned short)0 ) ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Bind arguments are inconsistent.\n", stderr );
		/*
		** Set fatal error flag to true.
		*/
		fatal_error_flag = 1;
	}

	if ( cfg->dfile_name == (char *)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "DFile name was null.\n", stderr );
		/*
		** Set fatal error flag to true.
		*/
		fatal_error_flag = 1;
	}

	if ( cfg->data_file_path == (char *)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "File data_file_path was null.\n", stderr );
		/*
		** Set fatal error flag to true.
		*/
		fatal_error_flag = 1;
	}

	if ( buffer_block_cnt == (unsigned short)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Must specify number of I/O blocks for buffer.\n", stderr );
		/*
		** Set fatal error flag to true.
		*/
		fatal_error_flag = 1;
	}

	if ( buffer_cnt == (unsigned short)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Must specify number of I/O buffers.\n", stderr );
		/*
		** Set fatal error flag to true.
		*/
		fatal_error_flag = 1;
	}

	if ( fatal_error_flag ) {
		/*
		** One or more of the function arguments were incorrect.
		*/
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
