/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <ctype.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function parses field name from record layout line of text. End of
** field name is expected to be one or more white space characters.
*/

int _dfile_parse_registry_field( char **rec )
{
	register char	*ptr;

	assert( rec != (char **)0 );
	assert( *rec != (char *)0 );

	DEBUG_FUNC_START;

	ptr = *rec;

	while ( *ptr != (char)0 ) {
		if ( isspace( *ptr ) ) {
			break;
		}
		++ptr;
	}

	if ( *ptr == (char)0 ) {
		/*
		** End of line reached.
		*/
		RETURN_INT( -1 );
	}

	/*
	** Null terminate field by overwriting white space character.
	*/
	*ptr = (char )0;
	*rec = &ptr[ 1 ];

	RETURN_INT( 0 );
}
