/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


#ifdef DFILE_THREAD

/*
** This function starts an I/O thread.
*/

int _dfile_create_thread( pthread_t *thread, void * ( *thread_func )( void * ), dfile_t *dfile )
{
	pthread_attr_t	attribute;
	int	ret;

	assert( thread != (pthread_t *)0 );
	assert( thread_func != (void * (*)( void * ))0 );
	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	ret = pthread_attr_init( &attribute );
	if ( ret != 0 ) {
		thread_error( "pthread_attr_init() failed", __FILE__, __LINE__, ret );
		RETURN_INT( -1 );
	}

	ret = pthread_create( thread, &attribute, thread_func, (void *)dfile );
	if ( ret != 0 ) {
		thread_error( "pthread_create() failed", __FILE__, __LINE__, ret );
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
#endif
