/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <zlib.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function copies data from the raw GZIP data stream without being
** inflated. Header and trailer data from GZIP file are examples of raw
** data that is not inflated.
*/

int _dfile_copy_raw_gz_data( unsigned char *result, size_t result_length, dfile_t *dfile )
{
	size_t	avail_in, remaining_cnt;
	z_stream	*zstream;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	zstream = (z_stream *)dfile->zstream;
	assert( zstream != (z_stream *)0 );

	if ( zstream->avail_in >= (unsigned)result_length ) {
		/*
		** Copy entire header.
		*/
		if ( result != (unsigned char *)0 ) {
			(void) memcpy( (void *)result, (void *)zstream->next_in, result_length );
		}
		zstream->next_in = &zstream->next_in[ result_length ];
		zstream->avail_in -= result_length;
	} else {
		/*
		** Buffer fault.
		** Copy first part.
		*/
		avail_in = (size_t)zstream->avail_in;
		if ( result != (unsigned char *)0 ) {
			(void) memcpy( (void *)result, (void *)zstream->next_in, avail_in );
		}
		remaining_cnt = result_length - avail_in;

		/*
		** Read remaining portion from file.
		*/
		if ( _dfile_read_gz_file( dfile ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( remaining_cnt > zstream->avail_in ) {
			/*
			** Not enough gzip data was read from file.
			*/
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Could not read enough data from zipped file.\n", stderr );
			RETURN_INT( -1 );
		}

		/*
		** Append remainder of header.
		*/
		if ( result != (unsigned char *)0 ) {
			(void) memcpy( (void *)&result[ avail_in ], (void *)zstream->next_in, remaining_cnt );
		}
		zstream->next_in = &zstream->next_in[ remaining_cnt ];
		zstream->avail_in -= remaining_cnt;
	}

	RETURN_INT( 0 );
}
