/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */


#ifndef _H_STDIO
#include <stdio.h>
#endif

#define	CFG_ENV_PATH	"CFGPATH"

/*
** internal library functions
*/
dfile_parse_t _dfile_parse_field( char **, size_t *, dfile_rec_t );

dfile_parse_t _dfile_parse_escaped_field( char **, size_t *, dfile_rec_t );

int _dfile_read_open_file( dfile_t * );

int _dfile_escaped_overflow( const char **, const char *, size_t, dfile_rec_t );

int _dfile_overflow( const char **, const char *, size_t, dfile_rec_t );

int _dfile_refill_ascii_buffer( dfile_t * );

int _dfile_read_gz_header( dfile_t * );

int _dfile_refill_zipped_buffer( dfile_t * );

dfile_format_t _dfile_identify_format( const char * );

int _dfile_set_refill_buffer_func( dfile_t * );

int _dfile_resize_overflow( char **, size_t *, size_t );

int _dfile_check_zipped_crc( dfile_t * );

void _dfile_free( dfile_t * );

int _dfile_allocate_zipped_stream( dfile_t *, char );

dfile_buffer_t *_dfile_create_buffers( unsigned short, const dfile_state_t * );

int _dfile_format_str_field( char **, const char *, const char **, dfile_rec_t );

int _dfile_allocate_buffer( dfile_t *, const char * );

int _dfile_write_open_file( dfile_t * );

int _dfile_flush_ascii_buffer( dfile_t * );

int _dfile_format_field( char **, const char *, const char **, size_t *, dfile_rec_t );

int _dfile_format_escaped_field( char **, const char *, const char **, size_t *, dfile_rec_t );

int _dfile_format_escaped_str_field( char **, const char *, const char **, dfile_rec_t );

void _dfile_write_gz_header( dfile_t * );

int _dfile_flush_zipped_buffer( dfile_t * );

int _dfile_write_zipped_crc( dfile_t * );

int _dfile_read_registry_field_file( char ***, unsigned short *, FILE * );

int _dfile_skip_spaces( char ** );

int _dfile_parse_registry_field( char ** );

void _dfile_parse_registry_field_rec( char **, char *, unsigned short );

int _dfile_read_gz_file( dfile_t * );

int _dfile_copy_raw_gz_data( unsigned char *, size_t, dfile_t * );

dfile_parse_t _dfile_parse_record( dfile_t * );

dfile_parse_t _dfile_get_record( dfile_t * );

int _dfile_alloc_bind_fields( dfile_bind_t *, unsigned short );

char *_dfile_sub_tags( const char *, const dfile_tag_t *, unsigned short );

int _dfile_vdate_rwopen_args( const dfile_cfg_t *, const dfile_bind_t *, unsigned short, unsigned short, unsigned short );

dfile_t *_dfile_construct( const dfile_cfg_t *, const dfile_bind_t *, unsigned short, const dfile_tag_t *, unsigned short, unsigned short, unsigned short, const dfile_state_t * );

int _dfile_var_rec_refill_ascii_buffer( dfile_t * );

int _dfile_var_rec_refill_zipped_buffer( dfile_t * );

void _dfile_var_record_append_overflow( dfile_t * );

int _dfile_var_record_save_overflow( dfile_t *, char *, dfile_buffer_t *, char *, unsigned short, unsigned short );

int _dfile_process_delimited_record( dfile_t *, dfile_buffer_t * );

int _dfile_process_variable_record( dfile_t *, dfile_buffer_t * );

int _dfile_process_read( dfile_t * );

void _dfile_read_eof_processing( dfile_t *, dfile_buffer_t * );

int _dfile_advance_buffer( dfile_t *, dfile_buffer_t * );

int _dfile_copy_field_to_buffer( dfile_t *, const char *, const size_t * );

dfile_parse_t _dfile_get_var_record( dfile_t * );

int _dfile_parse_record_failure( dfile_t *, unsigned short );

int _dfile_var_field_failure( dfile_t *, unsigned short );

int _dfile_create_bind_hash_table( void **, dfile_bind_t *, unsigned short );

int _dfile_bind( dfile_bind_t **, unsigned short, const dfile_bind_t *, unsigned short );

#ifdef DFILE_THREAD
void *_dfile_buffer_read_thread( void * );

void *_dfile_buffer_write_thread( void * );

int _dfile_buffer_wait( dfile_buffer_t *, dfile_buffer_state_t, unsigned short );

int _dfile_create_thread( pthread_t *, void * ( * )( void * ), dfile_t * );

int _dfile_process_threaded_read( dfile_t * );

int _dfile_release_buffer( dfile_buffer_t * );
#endif
