/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <regex.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_transform.h"


/*
** This function opens a data file.
*/
int open_dfile( dfile_t **dfile, const char *dfile_name, dfile_tag_t *tag_tbl, unsigned short tag_tbl_cnt, int thread_flag, char io_flag )
{
	dfile_cfg_t	cfg;
	const unsigned short	blocks_per_buffer_cnt = 4;
	const unsigned short	single_buffer = 1;
	const unsigned short	multiple_buffers = 3;
	unsigned short	buffer_cnt;

	assert( dfile != (dfile_t **)0 );
	assert( dfile_name != (const char *)0 );
	assert( io_flag == 'r' || io_flag == 'w' );

	DEBUG_FUNC_START;

	*dfile = (dfile_t *)0;

	if ( dfile_cfg( &cfg, dfile_name ) == -1 ) {
		RETURN_INT( -1 );
	}

	buffer_cnt = ( thread_flag ) ? multiple_buffers : single_buffer;

	switch ( io_flag ) {
	case 'r':
		*dfile = dfile_read_open( &cfg, (dfile_bind_t *)0, (unsigned short)0, tag_tbl, tag_tbl_cnt, blocks_per_buffer_cnt, buffer_cnt );
		break;
	case 'w':
		*dfile = dfile_write_open( &cfg, (dfile_bind_t *)0, (unsigned short)0, tag_tbl, tag_tbl_cnt, blocks_per_buffer_cnt, buffer_cnt, Dfile_trunc );
		break;
	default:
		(void) fputs( "Programming error! io_flag = [", stderr );
		(void) fputc( io_flag, stderr );
		(void) fputs( "].\n", stderr );
		abort();
	}

	if ( *dfile == (dfile_t *)0 ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
