/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

typedef struct {
	char	*input_field_name;
	char	*output_field_name;
	char	trnsfrm_flag;
	char	*search_str;
	regex_t	reg_exp;
	regmatch_t	*regmatch;
	char	*replacement;
	size_t	replacement_len;
	char	result[1024];
	dfile_bind_t	*input_bind;
	dfile_bind_t	*output_bind;
} trnsfrm_t;

int get_args( int, char * const [], const char **, const char **, int *, int *, dfile_tag_t **, unsigned short *, const char **, const char **, const char ** );

int open_dfile( dfile_t **, const char *, dfile_tag_t *, unsigned short, int, char );

void copy_record_to_bind( dfile_bind_t *, dfile_bind_t *, const unsigned short *, unsigned short );

int process_file( trnsfrm_t *, unsigned short, dfile_t *, dfile_t *, unsigned short *, void *, void * );

int output_record( dfile_t *, void * );

int compile_filters( void **, void **, const char *, const char *, dfile_t *, dfile_t * );

int load_control_file( trnsfrm_t **, unsigned short *, const char * );

int assign_bind( trnsfrm_t *, unsigned short, dfile_bind_t **, unsigned short, dfile_bind_t **, unsigned short );

int process_trnsfrm( trnsfrm_t *, unsigned short );

int trnsfrm_regex( char **, size_t *, const char *, size_t, trnsfrm_t * );
